<?php

namespace BplanModules\VisitorManagement\Providers;


use App\Models\User;
use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitType;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;


class NavigationServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        View::composer('*', function ($view) {
            $User = Auth::user() ?? new User();

            $navigation['visit-access-authorizations'] = (
                VisitType::where('active',1)
                    ->where('identifier', VisitTypeIdentifier::AccessAuthorization->value)
                    ->exists()
                    && (
                        $User->hasRole('Admin') || $User->hasMinAccessLevel('SystemManager')
                    )
                );

            $navigation['visit-appointments'] = $User->hasRole('Host') || $User->hasRole('Report') || $User->hasMinAccessLevel('SystemManager');

            $navigation['visit-logistic-queue'] = (
                VisitType::where('active', 1)
                    ->where(function ($query) {
                        $query->where('identifier', VisitTypeIdentifier::Pickup->value)
                            ->orWhere('identifier', VisitTypeIdentifier::Delivery->value)
                            ->orWhere('identifier', VisitTypeIdentifier::DeliveryAndPickup->value);

                    })->exists()
                    && (
                        $User->hasRole('Logistics') || $User->hasMinAccessLevel('SystemManager')
                    )
                );

            //   && ($User->hasRole('Host') || $User->hasMinAccessLevel('SystemManager'))
            $navigation['visit-visitors'] = (
                config('visitor-management.navigation.visitors', false)
                && ($User->hasRole('Host') || $User->hasMinAccessLevel('SystemManager')
            ));
            //MORE
            $navigation['visit-contact-groups'] = config('visitor-management.navigation.contact-groups', false);
            $navigation['visit-contact-options'] = config('visitor-management.navigation.contact-options', false);
            $navigation['visit-countries'] = config('visitor-management.navigation.countries', false);
            $navigation['visit-opening-hours'] = config('visitor-management.navigation.opening-hours', false);
            $navigation['visit-reasons'] = config('visitor-management.navigation.visit-reasons', false);

            //   && ($User->hasRole('Admin') || $User->hasMinAccessLevel('SystemManager'))
            $navigation['visit-more'] = $navigation['visit-reasons'] || $navigation['visit-contact-groups'] || $navigation['visit-contact-options'] || $navigation['visit-countries'] || $navigation['visit-opening-hours'];

            // --
            //  $User->hasRole('Admin') || $User->hasMinAccessLevel('SystemManager')
            $navigation['visit-employees'] = config('visitor-management.navigation.employees', false);
            $navigation['visit-equipment-items'] = config('visitor-management.navigation.equipment-items', false);
            $navigation['visit-documents'] = config('visitor-management.navigation.documents', false);
            $navigation['visit-locations'] = config('visitor-management.navigation.locations', false);
            $navigation['visit-users'] = config('visitor-management.navigation.users', false);


            // $navigation['visit-access-authorizations'] = true;
            // $navigation['visit-appointments'] = true;
            // $navigation['visit-contact-groups'] = true;
            // $navigation['visit-contact-options'] = true;
            // $navigation['visit-countries'] = true;
            // $navigation['visit-opening-hours'] = true;
            // $navigation['visit-reasons'] = true;
            // $navigation['visit-visitors'] = true;

            // $navigation['visit-more'] = true;

            // $navigation['visit-employees'] = true;
            // $navigation['visit-equipment-items'] = true;
            // $navigation['visit-documents'] = true;
            // $navigation['visit-locations'] = true;
            // $navigation['visit-users'] = true;





            $view->with('navigation', $navigation);
        });
    }
}
