<?php
/**
 * Repository Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:43
 * @package     bplan-modules/visitor-management
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Repositories;


use BplanModules\VisitorManagement\Models\VisitEmployee;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     2.1.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitEmployeeRepository
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Ermittelt die ID zu den übergebenen Employee-Daten
     *
     * Zwar wird zur Identifizierung nur die E-Mail-Adresse verwendet (weil das aktuell das einzige
     * eindeutige Merkmal des Employees ist), trotzdem wird ein Array mit allen Daten des Employees
     * erwartet. Der Grund dafür ist, dass zu einem späteren Zeitpunkt eventuell noch weitere
     * eindeutige Merkmale, die zur Identifizierung genutzt werden können, hinzukommen werden.
     *
     * @todo        Funktionalität überdenken: Bei Avient ist die personnel_number eindeutig.
     *
     * @param       array $employee
     *
     * @param       bool $ignoreCache
     *              Steuert die Verwendung des Methoden-Cache beim Ermitteln des Ergebnisses.
     *              Wenn TRUE übergeben wird, dann wird ein Datenbankzugriff durchgeführt, auch wenn
     *              der Methoden-Cache bereits einen passenden Eintrag enthält.
     *              Die Speicherung eines Wertes im Methoden-Cache wird von diesem Parameter nicht
     *              beeinflusst.
     *
     * @return      int|null
     *              Liefert die ID des Employees oder NULL, wenn der Employee nicht gefunden werden
     *              konnte.
     *
     * @version     1.0.0 / 2024-10-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function findEmployeeID(array $employee, bool $ignoreCache = false): int|null
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            if ($cache[$cacheKey] === false) {
                return null;
            }
            return $cache[$cacheKey];
        }
        $Employee = VisitEmployee::where('email', '=', $employee['email'])
            ->first();

        if ($Employee === null) {
            $cache[$cacheKey] = false;

            return null;
        }
        return $cache[$cacheKey] = $Employee->id;

    } // findEmployeeID()


    /**
     * Returns a collection of models
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By setting this parameter
     *              to TRUE, the inactive data records can also be read out.
     *
     * @return      Collection
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(bool $ignoreCache = false, bool $withInactive = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = VisitEmployee::query();

        if ($withInactive === false) {
            $Query->where('active', '=', 1);
        }
        return $cache[$cacheKey] = $Query->get();

    } // getAll()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      VisitEmployee
     *
     * @version     2.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $returnOrFail = true): VisitEmployee
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = VisitEmployee::query();

        if ($returnOrFail === true) {
            return $Query->find($id);
        }
        return $Query->findOrFail($id);

    } // getById()


} // class VisitEmployeeRepository {}
