<?php
/**
 * Repository Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-19 22:01:37
 * @package     bplan-modules/visitor-management
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Repositories;


use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitReason;
use BplanModules\VisitorManagement\Models\VisitType;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     2.1.0 / 2025-04-19
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitTypeRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Returns a collection of models
     *
     * @param       array|null|string $excludeIdentifier
     *              A character string or an array of identifiers to be excluded from the result.
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $withInactive
     *              By default, only the active data records are returned. By setting this parameter
     *              to TRUE, the inactive data records can also be read out.
     *
     * @param       bool $withInternal
     *              By default, only the data records marked as “internal = 0” are read out. By
     *              setting this parameter to TRUE, the internal status is ignored and all data
     *              records are read.
     *
     * @return      Collection
     *
     * @version     3.0.0 / 2025-03-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getAll(array|null|string $excludeIdentifier = null, bool $ignoreCache = false, bool $withInactive = false, bool $withInternal = false): Collection
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = VisitType::query();

        if ($withInactive === false) {
            $Query->where('active', '=', 1);
        }
        if ($withInternal === false) {
            $Query->where('internal', '=', 0);
        }
        if ($excludeIdentifier !== null) {
            if (is_string($excludeIdentifier)) {
                $excludeIdentifier = (array) $excludeIdentifier;
            }
            $Query->whereNotIn('identifier', $excludeIdentifier);
        }
        return $cache[$cacheKey] = $Query->get();

    } // getAll()


    /**
     * Returns the model instance for the given ID
     *
     * @param       int|string $id
     *
     * @param       bool $ignoreCache
     *              Controls the use of the method cache when determining the result.
     *              If TRUE is passed, a database access is carried out even if the method cache
     *              already contains a suitable entry. The storage of a value in the method cache
     *              is not affected by this parameter.
     *
     * @param       bool $returnOrFail
     *              Controls the return of the method.
     *              If no suitable entry can be found in the database, either NULL is returned (TRUE)
     *              or an exception is thrown (FALSE). This allows the result of the method call to
     *              be used directly in the Api controller.
     *
     * @throws      Illuminate\Database\Eloquent\ModelNotFoundException
     *
     * @return      VisitType
     *
     * @version     2.0.0 / 2025-04-19
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getById(int|string $id, bool $ignoreCache = false, bool $returnOrFail = true): VisitType
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = VisitType::query();

        if ($returnOrFail === true) {
            return $Query->find($id);
        }
        return $Query->findOrFail($id);

    } // getById()


    /**
     * Liefert den VisitType zum übergebenen Identifier
     *
     * @param       string|VisitTypeIdentifier $identifier
     *              Der Identifier kann wahlweise als String oder als Enum übergeben werden.
     *
     * @param       bool $ignoreCache
     *              Steuert die Verwendung des Methoden-Cache beim Ermitteln des Ergebnisses.
     *              Wenn TRUE übergeben wird, dann wird ein Datenbankzugriff durchgeführt, auch wenn
     *              der Methoden-Cache bereits einen passenden Eintrag enthält.
     *              Die Speicherung eines Wertes im Methoden-Cache wird von diesem Parameter nicht
     *              beeinflusst.
     *
     * @return      VisitReason
     *
     * @version		2.0.0 / 2025-03-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByIdentifier(string|VisitTypeIdentifier $identifier, bool $ignoreCache = false): VisitType
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        $Query = VisitType::where('identifier', '=', $identifier);

        return $cache[$cacheKey] = $Query->firstOrFail();

    } // getByIdentifier()


    /**
     * Liefert den VisitType zum übergebenen VisitReason
     *
     * @param       string|VisitReason $visitReason
     *              Eine VisitReason-Objekt oder eine VisitReason-ID.
     *
     * @param       bool $ignoreCache
     *              Steuert die Verwendung des Methoden-Cache beim Ermitteln des Ergebnisses.
     *              Wenn TRUE übergeben wird, dann wird ein Datenbankzugriff durchgeführt, auch wenn
     *              der Methoden-Cache bereits einen passenden Eintrag enthält.
     *              Die Speicherung eines Wertes im Methoden-Cache wird von diesem Parameter nicht
     *              beeinflusst.
     *
     * @return      VisitReason
     *
     * @version		1.0.0 / 2024-10-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByVisitReason(string|VisitReason $visitReason, bool $ignoreCache = false): VisitType
    {
        static $cache = [];

        $cacheKey = md5(serialize(func_get_args()));

        if ($ignoreCache === false && isset($cache[$cacheKey])) {
            return $cache[$cacheKey];
        }
        if (!$visitReason instanceof VisitReason) {
            $visitReason = VisitReasonRepository::getById($visitReason);
        }
        return $cache[$cacheKey] = VisitType::findOrFail($visitReason->visit_type_id);

    } // getByVisitReason()


} // class VisitTypeRepository {}
