<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_opening_hours');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_opening_hours', function (Blueprint $Table) {
            $Table->id();
            $Table->boolean('active')->default(1);

            $Table->timestamps();
            $Table->softDeletes('deleted_at');

            $Table->time('begin')->nullable();
            $Table->time('end')->nullable();
            $Table->boolean('open')->default(1);
            $Table->foreignId('visit_type_id')->constrained(table: 'visit_types', indexName: 'visit_opening_hours_FK_visit_type_id');
            $Table->unsignedTinyInteger('weekday');

            $Table->index('visit_type_id',               'visit_opening_hours_FKI_visit_type_id');
            $Table->unique(['visit_type_id', 'weekday'], 'visit_opening_hours_UKI_visit_type_id_weekday');

            new CodeGenerator($Table, [
                'appends' => [
                    'currently_open' => true,
                ],
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'open' => [
                        'sortable' => true,
                    ],
                    'visit_type_id' => [
                        'sortable' => true,
                    ],
                    'weekday' => [
                        'rules' => [
                            'required',
                            'integer',
                            'digits_between:0,6',
                        ],
                    ],
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
            ]);

        });
    } // up()


};
