<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_appointment_equipment_item');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_appointment_equipment_item', function (Blueprint $Table) {
            $Table->id();

            $Table->unsignedInteger('amount');
            $Table->foreignId('appointment_id')->constrained(table: 'visit_appointments', indexName: 'visit_appointment_equipment_item_FK_appointment_id');
            $Table->foreignId('equipment_item_id')->constrained(table: 'visit_equipment_items', indexName: 'visit_appointment_equipment_item_FK_equipment_item_id');

            $Table->index('appointment_id',    'visit_appointment_equipment_item_FKI_appointment_id');
            $Table->index('equipment_item_id', 'visit_appointment_equipment_item_FKI_equipment_item_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'appointment_id' => [
                        'appointment_id' => [
                            // 'relationName' => 'appointments',
                            // 'reverseRelationName' => 'appointments', //  todo    Weder "relationName" noch "reverseRelationName" haben einen Effekt bei Pivot-Tabellen
                        ],
                    ],
                    'equipment_item_id' => [
                        //'relationName' => 'equipment-items',
                        // 'reverseRelationName' => 'equipment-items',
                    ],
                ],
                'pivot' => [
                    'appends' => true,     //  TRUE (Standard) = alle zusätzlichen Felder in der Relationen-Methode im Model anhängen. FALSE = keine Felder anhängen, Array (hier z.B. ['amount']) = nur die enthaltenen Felder anhängen.
                    'relations' => [
                        'appointment_id' => 'visit_appointments',
                        'equipment_item_id' => 'visit_equipment_items',
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
            ]);

        });
    } // up()


};
