<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders\Dev;


use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (User::find(1) === null) {
            $date = date('Y-m-d H:i:s');

            $users = [
                [
                    "id" => 1,
                    "created_at" => $date,
                    "updated_at" => $date,
                    "email" => "system@bplan-solutions.de",
                    "internal" => 1,
                    "name" => "system",
                    "password" => '',
                ], [
                    "id" => 2,
                    "created_at" => $date,
                    "updated_at" => $date,
                    "email" => "core.developer@bplan-solutions.de",
                    "internal" => 1,
                    "name" => "Developer",
                    "password" => '$2y$12$UikvVY5tJiFKqIetjWDHaOg6sC/rgLtw/hDR01HuftNVTS/2.1PUu',
                ], [
                    "id" => 3,
                    "created_at" => $date,
                    "updated_at" => $date,
                    "email" => "core.maintainer@bplan-solutions.de",
                    "internal" => 1,
                    "name" => "Maintainer",
                    "password" => '$2y$12$UikvVY5tJiFKqIetjWDHaOg6sC/rgLtw/hDR01HuftNVTS/2.1PUu',
                ], [
                    "id" => 4,
                    "created_at" => "2024-05-24 18:09:13",
                    "updated_at" => "2024-05-24 21:30:31",
                    "email" => "wassilios.meletiadis@bplan-solutions.de",
                    "internal" => 1,
                    "name" => "Wassilios Meletiadis",
                    "password" => '$2y$12$UikvVY5tJiFKqIetjWDHaOg6sC/rgLtw/hDR01HuftNVTS/2.1PUu',
                ], [
                    "id" => 5,
                    "created_at" => "2024-05-24 18:09:13",
                    "updated_at" => "2024-05-24 21:30:31",
                    "email" => "andrea.bockholt@bplan-solutions.de",
                    "internal" => 0,
                    "name" => "Andrea Bockholt",
                    "password" => '$2y$12$UikvVY5tJiFKqIetjWDHaOg6sC/rgLtw/hDR01HuftNVTS/2.1PUu',
                ], [
                    "id" => 6,
                    "created_at" => "2024-05-24 18:09:13",
                    "updated_at" => "2024-05-24 21:30:31",
                    "email" => "tolga.kocer@bplan-solutions.de",
                    "internal" => 0,
                    "name" => "Tolga Kocer",
                    "password" => '$2y$12$UikvVY5tJiFKqIetjWDHaOg6sC/rgLtw/hDR01HuftNVTS/2.1PUu',
                ], [
                    "id" => 7,
                    "created_at" => "2024-05-24 18:09:13",
                    "updated_at" => "2024-05-24 21:30:31",
                    "email" => "emilio.cannarozzo@bplan-solutions.de",
                    "internal" => 1,
                    "name" => "Emilio Cannarozzo",
                    "password" => '$2y$12$UikvVY5tJiFKqIetjWDHaOg6sC/rgLtw/hDR01HuftNVTS/2.1PUu',
                ], [
                    "id" => 8,
                    "created_at" => "2024-05-24 18:09:13",
                    "updated_at" => "2024-05-24 21:30:31",
                    "email" => "host@bplan-solutions.de",
                    "internal" => 0,
                    "name" => "Host User",
                    "password" => '$2y$12$UikvVY5tJiFKqIetjWDHaOg6sC/rgLtw/hDR01HuftNVTS/2.1PUu',
                ], [
                    "id" => 9,
                    "created_at" => "2024-05-24 18:09:13",
                    "updated_at" => "2024-05-24 21:30:31",
                    "email" => "logistics@bplan-solutions.de",
                    "internal" => 0,
                    "name" => "Logistics User",
                    "password" => '$2y$12$UikvVY5tJiFKqIetjWDHaOg6sC/rgLtw/hDR01HuftNVTS/2.1PUu',
                ], [
                    "id" => 10,
                    "created_at" => "2024-05-24 18:09:13",
                    "updated_at" => "2024-05-24 21:30:31",
                    "email" => "host.logistics@bplan-solutions.de",
                    "internal" => 0,
                    "name" => "Host & Logistics User",
                    "password" => '$2y$12$UikvVY5tJiFKqIetjWDHaOg6sC/rgLtw/hDR01HuftNVTS/2.1PUu',
                ],
            ];
            $password = 'Test!234';
            $outputs = [];

            foreach ($users as & $user) {
                $user['password'] = Hash::make($password);

                $outputs[] = [
                    'username' => $user['email'],
                    'password' => $password
                ];
            }
            User::insert($users);

            $this->command->info("\n");

            foreach ($outputs as $output) {
                $this->command->info('    '.$output['username'].'/'.$output['password']);
            }
            $this->command->info("\n");
        }
    } // run()

} // class UserSeeder extends Seeder {}
