<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders\Dev;


use BplanModules\VisitorManagement\Enums\ContactOptionContext;
use BplanModules\VisitorManagement\Models\VisitContactOption;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitContactOptionSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        VisitContactOption::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "context" => ContactOptionContext::TerminalHelp->name,
                "labels" => '{"de":"Lager", "en":"Store", "it":"Magazzino"}',
                "sort_sequence" => 2,
                "value" => '+491638441315',
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "context" => ContactOptionContext::TerminalHelp->name,
                "labels" => '{"de":"Zentrale", "en":"Main office", "it":"Centrale"}',
                "sort_sequence" => 1,
                "value" => '+491638441315',
            ],

        ]);

    } // run()

} // class VisitContactOptionSeeder extends Seeder {}
