<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders;


use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PostDatabaseSeeder extends Seeder
{

    /**
     * Seed the application's database.
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run(): void
    {
        if (config('app.env') === 'production') {
            $seeds = [
                PersonalAccessTokenSeeder::class,
            ];
        } elseif (config('app.env') === 'demo') {
            $seeds = [
                Dev\PersonalAccessTokenSeeder::class,
            ];

        } else {
            $seeds = [
                Dev\PersonalAccessTokenSeeder::class,
            ];
        }
        $this->call($seeds);

    } // run()

} // class PostDatabaseSeeder extends Seeder {}
