<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders;


use BplanBase\Globals\Models\Role;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RoleSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        Role::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => 'Admin',
                "internal" => 1,
                "labels" => '{"de": "Administrator", "en": "Administrator"}',
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => 'Host',
                "internal" => 0,
                "labels" => '{"de": "Gastgeber", "en": "Host"}',
            ], [
                "id" => 3,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => 'Logistics',
                "internal" => 0,
                "labels" => '{"de": "Logistik", "en": "Logistics"}',
            ], [
                "id" => 4,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => 'Report',
                "internal" => 0,
                "labels" => '{"de": "Report", "en": "Report"}',
            ],

        ]);

    } // run()

} // class RoleSeeder extends Seeder {}
