<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders;


use App\Models\User;
use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


/**
 *
 * @version     1.0.0 / 2024-08-13
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $users = [
            [
                "email" => "system@bplan-solutions.de",
                "internal" => 1,
                "name" => "system",
            ], [
                "email" => "wassilios.meletiadis@bplan-solutions.de",
                "internal" => 1,
                "name" => "Wassilios Meletiadis",
            ], [
                "email" => "emilio.cannarozzo@bplan-solutions.de",
                "internal" => 1,
                "name" => "Emilio Cannarozzo",
            ],
        ];
        $password = 'Test!234';
        $outputs = [];

        foreach ($users as & $user) {
            if ($user['name'] === 'system') {
                $user['password'] = '';
            } else {
                $user['password'] = Hash::make($password);
            }
            $outputs[] = [
                'username' => $user['email'],
                'password' => $password
            ];
        }
        User::insert($users);

        $this->command->info("\n");

        foreach ($outputs as $output) {
            $this->command->info('    '.$output['username'].'/'.$output['password']);
        }
        $this->command->info("\n");

    } // run()

} // class UserSeeder extends Seeder {}
