<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders;


use BplanBase\Globals\Enums\RequireStatus;
use BplanModules\VisitorManagement\Enums\VisitTypeGroupIdentifier;
use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitType;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitTypeSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        VisitType::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"license_plate_formatted": '.RequireStatus::Required->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::NotUsed->value.', "visitors": '.RequireStatus::NotUsed->value.'}',
                "identifier" => VisitTypeIdentifier::AccessAuthorization->name,
                "internal" => 1,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Internals->name,
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"drive_on_area_permitted": '.RequireStatus::NotUsed->value.', "license_plate_formatted": '.RequireStatus::NotUsed->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::NotUsed->value.', "order_number": '.RequireStatus::NotUsed->value.', "visitors": '.RequireStatus::Required->value.'}',
                "identifier" => VisitTypeIdentifier::BulkAppointment->name,
                "internal" => 1,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Visits->name,
            ], [
                "id" => 3,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"license_plate_formatted": '.RequireStatus::Optional->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::NotUsed->value.', "visitors": '.RequireStatus::NotUsed->value.'}',
                "identifier" => VisitTypeIdentifier::Contractor->name,
                "internal" => 0,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Visits->name,
            ], [
                "id" => 4,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"drive_on_area_permitted": 0, "license_plate_formatted": '.RequireStatus::Optional->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::Optional->value.', "visitors": '.RequireStatus::NotUsed->value.'}',
                "identifier" => VisitTypeIdentifier::Delivery->name,
                "internal" => 0,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Logistics->name,
            ], [
                "id" => 5,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"drive_on_area_permitted": 0, "license_plate_formatted": '.RequireStatus::Optional->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::Optional->value.', "visitors": '.RequireStatus::NotUsed->value.'}',
                "identifier" => VisitTypeIdentifier::DeliveryAndPickup->name,
                "internal" => 0,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Logistics->name,
            ], [
                "id" => 6,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"drive_on_area_permitted": '.RequireStatus::NotUsed->value.', "license_plate_formatted": '.RequireStatus::NotUsed->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::NotUsed->value.', "visitors": '.RequireStatus::Optional->value.'}',
                "identifier" => VisitTypeIdentifier::GroupVisit->name,
                "internal" => 0,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Visits->name,
            ], [
                "id" => 7,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"drive_on_area_permitted": '.RequireStatus::NotUsed->value.', "license_plate_formatted": '.RequireStatus::Recommended->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::NotUsed->value.', "visitors": '.RequireStatus::NotUsed->value.'}',
                "identifier" => VisitTypeIdentifier::ParcelService->name,
                "internal" => 0,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Logistics->name,
            ],[
                "id" => 8,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"drive_on_area_permitted": '.RequireStatus::NotUsed->value.', "license_plate_formatted": '.RequireStatus::Recommended->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::Optional->value.', "visitors": '.RequireStatus::NotUsed->value.'}',
                "identifier" => VisitTypeIdentifier::Pickup->name,
                "internal" => 0,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Logistics->name,
            ], [
                "id" => 9,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"drive_on_area_permitted": '.RequireStatus::NotUsed->value.', "license_plate_formatted": '.RequireStatus::Recommended->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::NotUsed->value.', "visitors": '.RequireStatus::NotUsed->value.'}',
                "identifier" => VisitTypeIdentifier::Shunting->name,
                "internal" => 0,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Logistics->name,
            ], [
                "id" => 10,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"drive_on_area_permitted": '.RequireStatus::NotUsed->value.', "license_plate_formatted": '.RequireStatus::NotUsed->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::NotUsed->value.', "visitors": '.RequireStatus::NotUsed->value.'}',
                "identifier" => VisitTypeIdentifier::SingleVisit->name,
                "internal" => 0,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Visits->name,
            ], [
                "id" => 11,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "dependencies" => '{"drive_on_area_permitted": '.RequireStatus::NotUsed->value.', "license_plate_formatted": '.RequireStatus::NotUsed->value.', "main_employee_id": '.RequireStatus::Optional->value.', "main_visitor_id": '.RequireStatus::Required->value.', "order_number": '.RequireStatus::NotUsed->value.', "visitors": '.RequireStatus::NotUsed->value.'}',
                "identifier" => VisitTypeIdentifier::Technician->name,
                "internal" => 0,
                "safety_briefing_valid_time" => 6,
                "visit_group" => VisitTypeGroupIdentifier::Visits->name,
            ],

        ]);
    } // run()

} // class VisitTypeSeeder extends Seeder {}
