<div>
    <div class="grid grid-cols-8 gap-2 w-full max-w-[23rem]">
        <input @keyup.enter="$wire.addLicensePlate" type="text" wire:model="licensePlate" id="licensePlate"
            class="col-span-6 bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
            placeholder="K-B-4711" required="">
        <button wire:click="addLicensePlate"
            class="col-span-2 text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm w-full sm:w-auto py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800 items-center inline-flex justify-center">
            <span id="default-message" class="text-ellipsis overflow-hidden px-1">
                @lang('globals::global.action.add')
            </span>
        </button>
    </div>
    <x-input-error for="licensePlate" />
    <div class="gap-1 text-gray-500 dark:text-gray-400 grid grid-cols-3 mt-2">
        @forelse ($licensePlates as $index => $licensePlate)
            <div class="col">
                <span id="badge-dismiss-default"
                    class="inline-flex items-center px-2 py-1 me-1 text-xs font-medium text-primary-800 bg-primary-100 rounded dark:bg-primary-900 dark:text-primary-300">
                    {{ $licensePlate }}
                    <button type="button" wire:click="removeLicensePlate({{ $index }})"
                        class="inline-flex items-center p-1 ms-2 text-sm text-primary-400 bg-transparent rounded-sm hover:bg-primary-200 hover:text-primary-900 dark:hover:bg-primary-800 dark:hover:text-primary-300"
                        data-dismiss-target="#badge-dismiss-default" aria-label="Remove">
                        <svg class="w-2 h-2" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                            viewBox="0 0 14 14">
                            <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                        </svg>
                    </button>
                </span>
            </div>
        @empty
        @endforelse
    </div>
</div>
