<div x-data="editContactGroup" x-cloak x-show="show" id="editContactGroupModal" tabindex="-1"
    x-on:show-edit-contact-group-modal.window="showModal()" x-on:contact-group-edited.window="edited($event)"
    x-on:contact-group-deleted.window="deleted($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path
                            d="M21.731 2.269a2.625 2.625 0 0 0-3.712 0l-1.157 1.157 3.712 3.712 1.157-1.157a2.625 2.625 0 0 0 0-3.712ZM19.513 8.199l-3.712-3.712-12.15 12.15a5.25 5.25 0 0 0-1.32 2.214l-.8 2.685a.75.75 0 0 0 .933.933l2.685-.8a5.25 5.25 0 0 0 2.214-1.32L19.513 8.2Z" />
                    </svg>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-contact-groups.modal.edit.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" reason="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div>
                        <input :disabled="editSucceeded" type="checkbox" wire:model="isActive" id="isActive"
                            class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-primary-600 focus:ring-primary-500 dark:focus:ring-primary-600 dark:ring-offset-gray-800 focus:ring-2 dark:bg-gray-700 dark:border-gray-600"
                            placeholder="@lang('globals::global.status.active')">
                        <label for="isActive" class="text-sm font-medium text-gray-900 ms-2 dark:text-gray-300">
                            @lang('globals::global.status.active')
                        </label>
                        <x-input-error for="isActive" />
                    </div>
                    <div class="col-start-1">
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="label" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('globals::global.label.label')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <x-visitor-management::global.input-multi-language-json :labelsJson="$labelsJson" target="edit" />
                    </div>
                </div>
                <div x-data="{ showRemove: false }" x-cloak x-show="!editSucceeded" class="flex justify-end">
                    {{-- <div class="flex items-center">
                        <button x-show="!showRemove" wire:loading.remove wire:target="deleteContactGroup"
                            class="text-red-600 dark:text-red-500 hover:underline" x-on:click="showRemove = true">
                            @lang('globals::global.action.delete')
                        </button>
                        <div x-cloak x-show="showRemove" wire:loading.remove wire:target="deleteContactGroup">
                            <p class="text-xs text-gray-900 dark:text-white">
                                @lang('globals::global.confirm.delete')</p>
                            <div>
                                <button x-on:click="showRemove = false"
                                    class="font-medium text-fkbgreen-700 dark:text-fkbgreen-600 hover:underline">
                                    @lang('globals::global.action.cancel')
                                </button>
                                <button x-on:click="showRemove = false" wire:click="deleteContactGroup"
                                    class="font-medium text-red-600 dark:text-red-500 hover:underline">
                                    @lang('globals::global.action.delete')
                                </button>
                            </div>
                        </div>
                    </div> --}}
                    <button wire:loading.remove wire:target="editContactGroup" wire:click="editContactGroup"
                        reason="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                            class="w-5 h-5 mr-1 -ml-1">
                            <path fill-rule="evenodd"
                                d="M19.916 4.626a.75.75 0 0 1 .208 1.04l-9 13.5a.75.75 0 0 1-1.154.114l-6-6a.75.75 0 0 1 1.06-1.06l5.353 5.353 8.493-12.74a.75.75 0 0 1 1.04-.207Z"
                                clip-rule="evenodd" />
                        </svg>
                        @lang('globals::global.action.save')
                    </button>
                    <x-global-components::global.loading-spinner wire:loading wire:target="editContactGroup, deleteContactGroup" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('editContactGroup', () => ({
                show: false,
                editSucceeded: false,

                deleted(event) {
                    this.editSucceeded = true;
                    this.hideModal();
                },
                edited(event) {
                    this.editSucceeded = true;
                    this.hideModal();
                },
                resetModal() {
                    this.editSucceeded = false;

                    @this.resetModal()
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(id) {
                    this.show = true;

                    setTimeout(() => {
                        // document.getElementById('label').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
