<div x-data="editContactNumberModal" x-cloak x-show="show" id="editContactNumberModal" tabindex="-1"
    x-on:show-edit-contact-option-modal.window="showModal($event)" x-on:contact-number-edited.window="edited($event)" x-on:contact-number-deleted="deleted($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path fill-rule="evenodd"
                            d="M1.5 4.5a3 3 0 0 1 3-3h1.372c.86 0 1.61.586 1.819 1.42l1.105 4.423a1.875 1.875 0 0 1-.694 1.955l-1.293.97c-.135.101-.164.249-.126.352a11.285 11.285 0 0 0 6.697 6.697c.103.038.25.009.352-.126l.97-1.293a1.875 1.875 0 0 1 1.955-.694l4.423 1.105c.834.209 1.42.959 1.42 1.82V19.5a3 3 0 0 1-3 3h-2.25C8.552 22.5 1.5 15.448 1.5 6.75V4.5Z"
                            clip-rule="evenodd" />
                    </svg>

                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-contact-options.modal.edit.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div>
                        <div class="flex items-center mb-2 space-x-1">
                            <label for="label" class="block text-sm font-medium text-gray-900 dark:text-white">
                                @lang('globals::global.placeholder.label')
                                <x-global-components::global.input-required-hint />
                            </label>
                        </div>
                        <x-visitor-management::global.input-multi-language-json :labelsJson="$labelsJson" target="edit" />
                        <x-input-error for="labelsJson" />
                    </div>
                    <div>
                        <div wire:ignore>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="phonenumber"
                                    class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-contact-options.label.phone-number')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editEmployee" type="tel"
                                 id="edit_phonenumber"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-contact-options.placeholder.phone-number')" required="">
                            <input type="hidden" id="phonenumber_int" wire:model="phonenumber" />
                        </div>
                        <x-input-error for="phonenumber" />
                    </div>
                </div>
                <div class="flex justify-between">
                    <div class="flex items-center">
                    <button x-show="!showRemove" class="text-red-600 dark:text-red-500 hover:underline"
                        x-on:click="showRemove = true">
                        @lang('globals::global.action.delete')
                    </button>
                    <div x-cloak x-show="showRemove" wire:loading.remove wire:target="deleteContactNumber">
                        <p class="text-xs text-gray-900 dark:text-white">
                            @lang('globals::global.confirm.delete')</p>
                        <div>
                            <button x-on:click="showRemove = false"
                                class="font-medium text-fkbgreen-700 dark:text-fkbgreen-600 hover:underline">
                                @lang('globals::global.action.cancel')
                            </button>
                            <button x-on:click="showRemove = false" wire:click="deleteContactNumber"
                                class="font-medium text-red-600 dark:text-red-500 hover:underline">
                                @lang('globals::global.action.delete')
                            </button>
                        </div>
                    </div>
                </div>
                    <button wire:loading.remove wire:target="editContactNumber" wire:click="editContactNumber"
                        type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                            class="w-5 h-5 mr-1 -ml-1">
                            <path fill-rule="evenodd"
                                d="M19.916 4.626a.75.75 0 0 1 .208 1.04l-9 13.5a.75.75 0 0 1-1.154.114l-6-6a.75.75 0 0 1 1.06-1.06l5.353 5.353 8.493-12.74a.75.75 0 0 1 1.04-.207Z"
                                clip-rule="evenodd" />
                        </svg>
                        @lang('globals::global.action.save')
                    </button>
                    <x-global-components::global.loading-spinner wire:loading wire:target="editContactNumber" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('editContactNumberModal', () => ({
                show: false,
                showRemove: false,
                editSucceeded: false,
                phonenumberInput: document.querySelector("#edit_phonenumber"),
                intlTelPhonenumberInput: null,

                setPhonenumber: (intlTelPhonenumberInput) => {
                    let number = intlTelPhonenumberInput.getNumber();
                    let countryData = intlTelPhonenumberInput.getSelectedCountryData();
                    @this.phonenumberDialCode = countryData.dialCode;
                    @this.phonenumber = number;
                },

                init() {
                    this.intlTelPhonenumberInput = intlTelInput(this.phonenumberInput, {
                        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@24.3.4/build/js/utils.js",
                        initialCountry: "de",
                        validationNumberType: "MOBILE",
                        autoPlaceholder: "aggressive",
                        formatOnDisplay: true,
                        separateDialCode: true,
                    });

                    this.phonenumberInput.addEventListener('keyup', () => {
                        this.setPhonenumber(this.intlTelPhonenumberInput);
                    });

                    this.phonenumberInput.addEventListener("countrychange", () => {
                        this.setPhonenumber(this.intlTelPhonenumberInput);
                    });
                },

                edited(event) {
                    this.editSucceeded = true;
                    this.hideModal();
                },
                deleted(event) {
                    this.hideModal();
                },
                resetModal() {
                    this.editSucceeded = false;
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(event) {
                    this.intlTelPhonenumberInput.setNumber(event.detail.contactOption.value);
                    let countryData = this.intlTelPhonenumberInput.getSelectedCountryData();
                    @this.phonenumberDialCode = countryData.dialCode;
                    @this.phonenumber = event.detail.contactOption.value;

                    this.show = true;

                    setTimeout(() => {
                        // document.getElementById('firstname').fcus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
