<div>
    <div class="my-4">
        <h2 class="text-4xl font-extrabold dark:text-white">
            @lang('visitor-management::visit-dashboard.page.heading')
        </h2>
        <p class="my-4 text-lg text-gray-500">
            @lang('visitor-management::visit-dashboard.page.description')
        </p>
    </div>
    <div class="relative bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
        @if (count($checkedInAppointments) > 0)
            <div class="overflow-x-auto">
                <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                    <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                        <tr>
                            <th scope="col" class="px-4 py-3">
                                @lang('globals::global.caption.id')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-dashboard.caption.arrived')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-dashboard.caption.visitor')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-dashboard.caption.visit-reason')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('visitor-management::visit-dashboard.caption.process-status')
                            </th>
                            <th scope="col" class="px-4 py-3">
                                @lang('globals::global.caption.action')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($checkedInAppointments as $checkedInAppointment)
                            <tr id="checkedInAppointment-{{ $checkedInAppointment->id }}"
                                class="border-b dark:border-gray-700">
                                <th scope="row"
                                    class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                    {{ $checkedInAppointment->id }}
                                </th>
                                <td class="px-4 py-3">
                                    {{ $checkedInAppointment?->checked_in_at?->format(__('globals::global.datetime.format')) }}
                                </td>
                                <td class="px-4 py-3">
                                    @if (isset($checkedInAppointment?->mainVisitor))
                                        {{ $checkedInAppointment?->mainVisitor?->last_name }},
                                        {{ $checkedInAppointment?->mainVisitor?->first_name }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="px-4 py-3">
                                    {{ $checkedInAppointment?->visitReason?->labels?->{app()->getLocale()} }}
                                    (@lang('visitor-management::visit-types.identifier.' . $checkedInAppointment->visitType?->identifier))
                                </td>
                                <td class="px-4 py-3">
                                    {{ ucfirst(__('visitor-management::visit-dashboard.status.' . \BplanModules\VisitorManagement\Enums\ProcessStatus::tryFrom($checkedInAppointment->process_status)?->name.'.'.$checkedInAppointment->visitType->visit_group)) }}
                                </td>
                                <td class="flex py-3 items-center space-x-4">
                                    <button
                                        :class="{ 'invisible': @js($checkedInAppointment->process_status < \BplanModules\VisitorManagement\Enums\ProcessStatus::Entered->value), 'bg-primary-700 text-white': @js($checkedInAppointment->equipmentItems->count() > 0), 'bg-white': @js($checkedInAppointment->equipmentItems->count() == 0) }"
                                        x-on:click="$dispatch('show-add-equipment-modal', { appointment: @js($checkedInAppointment) })"
                                        type="button" data-tippy-content="@lang('visitor-management::visit-dashboard.action.edit-equipment-items')"
                                        class="bg-white text-primary-700 border border-primary-700 hover:bg-primary-700 hover:text-white focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-full text-sm p-2.5 text-center inline-flex items-center dark:border-primary-500 dark:text-primary-500 dark:hover:text-white dark:focus:ring-primary-800 dark:hover:bg-primary-500">
                                        <svg class="size-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                            fill="currentColor">
                                            <path fill-rule="evenodd"
                                                d="M12 6.75a5.25 5.25 0 0 1 6.775-5.025.75.75 0 0 1 .313 1.248l-3.32 3.319c.063.475.276.934.641 1.299.365.365.824.578 1.3.64l3.318-3.319a.75.75 0 0 1 1.248.313 5.25 5.25 0 0 1-5.472 6.756c-1.018-.086-1.87.1-2.309.634L7.344 21.3A3.298 3.298 0 1 1 2.7 16.657l8.684-7.151c.533-.44.72-1.291.634-2.309A5.342 5.342 0 0 1 12 6.75ZM4.117 19.125a.75.75 0 0 1 .75-.75h.008a.75.75 0 0 1 .75.75v.008a.75.75 0 0 1-.75.75h-.008a.75.75 0 0 1-.75-.75v-.008Z"
                                                clip-rule="evenodd" />
                                            <path
                                                d="m10.076 8.64-2.201-2.2V4.874a.75.75 0 0 0-.364-.643l-3.75-2.25a.75.75 0 0 0-.916.113l-.75.75a.75.75 0 0 0-.113.916l2.25 3.75a.75.75 0 0 0 .643.364h1.564l2.062 2.062 1.575-1.297Z" />
                                            <path fill-rule="evenodd"
                                                d="m12.556 17.329 4.183 4.182a3.375 3.375 0 0 0 4.773-4.773l-3.306-3.305a6.803 6.803 0 0 1-1.53.043c-.394-.034-.682-.006-.867.042a.589.589 0 0 0-.167.063l-3.086 3.748Zm3.414-1.36a.75.75 0 0 1 1.06 0l1.875 1.876a.75.75 0 1 1-1.06 1.06L15.97 17.03a.75.75 0 0 1 0-1.06Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </button>
                                    <button
                                        x-on:click="$dispatch('show-check-out-modal', { appointment: @js($checkedInAppointment) })"
                                        type="button" data-tippy-content="@lang('visitor-management::visit-dashboard.action.check-out')"
                                        class="bg-white text-primary-700 border border-primary-700 hover:bg-primary-700 hover:text-white focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-full text-sm p-2.5 text-center inline-flex items-center dark:border-primary-500 dark:text-primary-500 dark:hover:text-white dark:focus:ring-primary-800 dark:hover:bg-primary-500">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                            stroke-width="1.5" stroke="currentColor" class="size-6">
                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                d="M15.75 9V5.25A2.25 2.25 0 0 0 13.5 3h-6a2.25 2.25 0 0 0-2.25 2.25v13.5A2.25 2.25 0 0 0 7.5 21h6a2.25 2.25 0 0 0 2.25-2.25V15m3 0 3-3m0 0-3-3m3 3H9" />
                                        </svg>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @if ($checkedInAppointments->lastPage() > 1)
                <div class="p-4">
                    {{ $checkedInAppointments->links() }}
                </div>
            @endif
        @else
            <div class="max-w-screen-xl px-4 py-8 mx-auto lg:py-16 lg:px-6">
                <div class="max-w-screen-sm mx-auto text-center">
                    <div class="flex justify-center">
                        <svg aria-hidden="true"
                            class="w-24 h-24 mb-4 font-extrabold tracking-tight lg:text-9xl text-primary-600 dark:text-primary-500"
                            fill="currentColor" viewbox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <p class="mb-4 text-3xl font-bold tracking-tight text-gray-900 md:text-4xl dark:text-white">
                        @lang('visitor-management::visit-dashboard.hint.no-checked-in-appointments')
                    </p>
                </div>
            </div>
        @endif
    </div>

    <livewire:visitor-management::visit-logistic-queue.modals.edit-equipment-items />
    <livewire:visitor-management::visit-dashboard.modals.check-out />
</div>
