<div x-data="checkOut" x-cloak x-show="show" id="checkOutModal" tabindex="-1"
    x-on:show-check-out-modal.window="showModal($event)" x-on:appointment-checked-out.window="edited($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M15.75 9V5.25A2.25 2.25 0 0 0 13.5 3h-6a2.25 2.25 0 0 0-2.25 2.25v13.5A2.25 2.25 0 0 0 7.5 21h6a2.25 2.25 0 0 0 2.25-2.25V15m3 0 3-3m0 0-3-3m3 3H9" />
                    </svg>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-dashboard.modal.check-out.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div>
                    <div class="mb-4 text-sm font-light text-center text-gray-500 dark:text-gray-400">
                        <h3 class="mb-3 text-2xl font-bold text-gray-900 dark:text-white">
                            {{ $appointment?->subject }}
                        </h3>
                        <p>
                            @lang('visitor-management::visit-dashboard.modal.check-out.description')
                        </p>
                    </div>
                </div>
                <div class="flex justify-end mt-4">
                    <button wire:loading.remove wire:target="checkOut" wire:click="checkOut" type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-6 mr-1 -ml-1">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M15.75 9V5.25A2.25 2.25 0 0 0 13.5 3h-6a2.25 2.25 0 0 0-2.25 2.25v13.5A2.25 2.25 0 0 0 7.5 21h6a2.25 2.25 0 0 0 2.25-2.25V15m3 0 3-3m0 0-3-3m3 3H9" />
                        </svg>
                        @lang('visitor-management::visit-dashboard.action.check-out')
                    </button>
                    <x-global-components::global.loading-spinner wire:loading wire:target="checkOut" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('checkOut', () => ({
                show: false,
                editSucceeded: false,

                init() {},
                edited(event) {
                    this.editSucceeded = true;
                    this.hideModal();
                },
                resetModal() {
                    this.editSucceeded = false;
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(event) {
                    this.show = true;

                    setTimeout(() => {
                        // document.getElementById('firstname').fcus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
