<div x-data="editEmployee" x-cloak x-show="show" id="editEmployeeModal" tabindex="-1"
    x-on:show-edit-employee-modal.window="showModal($event)" x-on:employee-edited.window="edited($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-5">
                        <path fill-rule="evenodd"
                            d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                            clip-rule="evenodd" />
                    </svg>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-employees.modal.edit.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div
                    class="text-sm font-medium text-center text-gray-500 border-b border-gray-200 dark:text-gray-400 dark:border-gray-700">
                    <ul class="flex flex-wrap -mb-px">
                        <li class="me-2" x-on:click="tab = 'main'">
                            <button type="button"
                                :class="{
                                    'hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300 border-transparent': tab !=
                                        'main',
                                    'active text-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500': tab ==
                                        'main'
                                }"
                                class="inline-block p-4 border-b-2 rounded-t-lg">
                                @lang('globals::global.action.save')
                            </button>
                        </li>
                        <li class="me-2" x-on:click="tab = 'accessAuthorizations'">
                            <button type="button"
                                :class="{
                                    'hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300 border-transparent': tab !=
                                        'accessAuthorizations',
                                    'active text-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500': tab ==
                                        'accessAuthorizations'
                                }"
                                class="inline-block p-4 border-b-2 rounded-t-lg" aria-current="page">
                                <div>
                                    @lang('visitor-management::visit-types.identifier.AccessAuthorization')
                                    <span
                                        class="items-center inline px-2 py-1 text-sm font-medium text-primary-800 bg-primary-100 rounded dark:bg-primary-900 dark:text-primary-300">
                                        {{ count($accessAuthorizations) }}
                                    </span>
                                </div>
                            </button>
                        </li>
                    </ul>
                </div>
                <div x-show="tab == 'main'" class="pt-4 max-h-96 overflow-y-scroll">
                    <div class="grid gap-4 mb-4 sm:grid-cols-2">
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="firstname" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-employees.label.first-name')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editEmployee" type="text" readonly
                                wire:model="firstname" id="firstname"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-employees.placeholder.firstname')" required="">
                            <x-input-error for="firstname" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="lastname" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-employees.label.last-name')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editEmployee" type="text" readonly
                                wire:model="lastname" id="lastname"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-employees.placeholder.lastname')" required="">
                            <x-input-error for="lastname" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="email" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('globals::global.label.email')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editEmployee" type="email" readonly
                                wire:model="email" id="email"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('globals::global.placeholder.email')" required="">
                            <x-input-error for="email" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="department" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-employees.label.department')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editEmployee" type="text" readonly
                                wire:model="department" id="department"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-employees.placeholder.department')" required="">
                            <x-input-error for="department" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="lastname" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-employees.label.function')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editEmployee" type="text" readonly
                                wire:model="function" id="function"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-employees.placeholder.function')" required="">
                            <x-input-error for="function" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="lastname" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-employees.label.contact-group')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editEmployee" type="text"
                                readonly wire:model="contactGroup" id="contactGroup"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-employees.placeholder.contact_group')" required="">
                            <x-input-error for="contactGroup" />
                        </div>
                        <div>
                            <div wire:ignore>
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="mobilenumber"
                                        class="block text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-employees.label.mobile-phone-number')
                                        <x-global-components::global.input-required-hint />
                                    </label>
                                </div>
                                <input :disabled="editSucceeded" @keyup.enter="$wire.editEmployee" type="tel"
                                    id="edit_mobilenumber"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::visit-employees.placeholder.mobile-phone-number')" required="">
                                <input type="hidden" id="mobilenumber_int" readonly />
                            </div>
                            <x-input-error for="mobilenumber" />
                        </div>
                        <div>
                            <div wire:ignore>
                                <div class="flex items-center mb-2 space-x-1">
                                    <label for="phonenumber"
                                        class="block text-sm font-medium text-gray-900 dark:text-white">
                                        @lang('visitor-management::visit-employees.label.phone-number')
                                        <x-global-components::global.input-required-hint />
                                    </label>
                                </div>
                                <input :disabled="editSucceeded" @keyup.enter="$wire.editEmployee" type="tel"
                                    id="edit_phonenumber"
                                    class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                    placeholder="@lang('visitor-management::visit-employees.placeholder.phone-number')" required="">
                                <input type="hidden" id="phonenumber_int" readonly />
                            </div>
                            <x-input-error for="phonenumber" />
                        </div>
                        {{-- <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="name"
                                    class="text-sm font-medium text-gray-900 dark:text-white inline-flex">
                                    @lang('visitor-management::visit-employees.label.license-plate')
                                    <x-global-components::global.information-icon data-tippy-content="{{__('global.license_plate_information')}}" />
                                </label>
                            </div>
                            <x-visitor-management::global.input-license-plates :licensePlates="$licensePlates" target="create" />
                        </div> --}}
                    </div>
                </div>
                <div x-show="tab == 'accessAuthorizations'" class="py-4 max-h-96 overflow-y-scroll">
                    <ul role="list" class="divide-y divide-white/5 space-y-2">
                        @forelse ($accessAuthorizations as $accessAuthorization)
                            <li>
                                <div
                                    class="rounded-lg border border-gray-200 bg-white p-6 shadow-sm dark:border-gray-700 dark:bg-gray-800">
                                    <div class="grid w-full grid-cols-2 sm:grid-cols-9 gap-3 sm:gap-0">
                                        <div class="sm:col-span-1 flex items-center">
                                            @if ($accessAuthorization->valid_from->lte(now()) && $accessAuthorization->valid_until->gte(now()))
                                                <svg data-tippy-content="{{ __('globals::global.status.active') }}"
                                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor" class="size-6 text-green-500">
                                                    <path fill-rule="evenodd"
                                                        d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm13.36-1.814a.75.75 0 1 0-1.22-.872l-3.236 4.53L9.53 12.22a.75.75 0 0 0-1.06 1.06l2.25 2.25a.75.75 0 0 0 1.14-.094l3.75-5.25Z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            @else
                                                <svg data-tippy-content="{{ __('globals::global.status.expired') }}"
                                                    xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                                                    fill="currentColor" class="size-6 text-red-500">
                                                    <path fill-rule="evenodd"
                                                        d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12ZM12 8.25a.75.75 0 0 1 .75.75v3.75a.75.75 0 0 1-1.5 0V9a.75.75 0 0 1 .75-.75Zm0 8.25a.75.75 0 1 0 0-1.5.75.75 0 0 0 0 1.5Z"
                                                        clip-rule="evenodd" />
                                                </svg>
                                            @endif
                                        </div>
                                        <div class="col-start-1 sm:col-span-3">
                                            <span class="font-semibold text-gray-900 dark:text-white">Valid from</span>
                                            <p>{{ $accessAuthorization->valid_from->format(__('globals::global.datetime.format')) }}
                                            </p>
                                        </div>
                                        <div class="sm:col-span-3">
                                            <span class="font-semibold text-gray-900 dark:text-white">to</span>
                                            <p>{{ $accessAuthorization->valid_until->format(__('globals::global.datetime.format')) }}
                                            </p>
                                        </div>
                                        <div class="flex justify-center sm:justify-end col-span-2">
                                            <a href="{{ route('visit-access-authorizations.index', ['id' => $accessAuthorization->id]) }}"
                                                class="py-2.5 px-5 me-2 mb-2 text-sm font-medium text-gray-900 focus:outline-none bg-white rounded-full border border-gray-200 hover:bg-gray-100 hover:text-primary-700 focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                                                @lang('globals::global.action.view')
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        @empty
                            @lang('visitor-management::visit-employees.info.not-found')
                        @endforelse
                    </ul>
                </div>
                {{-- <div class="flex justify-end mt-4">
                    <button wire:loading.remove wire:target="editEmployee" wire:click="editEmployee" type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg class="w-6 h-6 mr-1 -ml-1" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                                clip-rule="evenodd"></path>
                        </svg>
                        @lang('visitor-management::visit-employees.action.save')
                    </button>
                    <x-global-components::global.loading-spinner wire:loading wire:target="editEmployee" />
                </div> --}}
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('editEmployee', () => ({
                show: false,
                tab: 'main',
                editSucceeded: false,
                mobilenumberInput: document.querySelector("#edit_mobilenumber"),
                phonenumberInput: document.querySelector("#edit_phonenumber"),
                intlTelMobilenumberInput: null,
                intlTelPhonenumberInput: null,

                setMobilenumber: (intlTelMobilenumberInput) => {
                    let number = intlTelMobilenumberInput.getNumber();
                    let countryData = intlTelMobilenumberInput.getSelectedCountryData();
                    @this.mobilenumberDialCode = countryData.dialCode;
                    @this.mobilenumber = number;
                },
                setPhonenumber: (intlTelPhonenumberInput) => {
                    let number = intlTelPhonenumberInput.getNumber();
                    let countryData = intlTelPhonenumberInput.getSelectedCountryData();
                    @this.phonenumberDialCode = countryData.dialCode;
                    @this.phonenumber = number;
                },

                init() {
                    this.intlTelMobilenumberInput = intlTelInput(this.mobilenumberInput, {
                        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@24.3.4/build/js/utils.js",
                        initialCountry: "de",
                        nationalMode: true,
                        strictMode: true,
                        validationNumberType: "MOBILE",
                        placeholderNumberType: "MOBILE",
                        autoPlaceholder: "aggressive",
                        formatOnDisplay: true,
                        separateDialCode: true,
                    });

                    this.mobilenumberInput.addEventListener('keyup', () => {
                        this.setMobilenumber(this.intlTelMobilenumberInput);
                    });

                    this.mobilenumberInput.addEventListener("countrychange", () => {
                        this.setMobilenumber(this.intlTelMobilenumberInput);
                    });


                    this.intlTelPhonenumberInput = intlTelInput(this.phonenumberInput, {
                        utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@24.3.4/build/js/utils.js",
                        initialCountry: "de",
                        nationalMode: true,
                        strictMode: true,
                        validationNumberType: "FIXED_LINE",
                        placeholderNumberType: "FIXED_LINE",
                        autoPlaceholder: "aggressive",
                        formatOnDisplay: true,
                        separateDialCode: true,
                    });

                    this.phonenumberInput.addEventListener('keyup', () => {
                        this.setPhonenumber(this.intlTelPhonenumberInput);
                    });

                    this.phonenumberInput.addEventListener("countrychange", () => {
                        this.setPhonenumber(this.intlTelPhonenumberInput);
                    });

                },
                edited(event) {
                    this.editSucceeded = true;
                    this.hideModal();
                },
                resetModal() {
                    this.editSucceeded = false;

                    @this.resetModal()
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(event) {
                    this.show = true;
                    this.intlTelMobilenumberInput.setNumber(event?.detail?.employee?.mobile_phone_number ?? '');
                    let countryDataMobile = this.intlTelMobilenumberInput.getSelectedCountryData();
                    @this.mobilenumberDialCode = countryDataMobile.dialCode;
                    @this.mobilenumber = event?.detail?.employee?.mobile_phone_number;

                    this.intlTelPhonenumberInput.setNumber(event?.detail?.employee?.phone_number ?? '');
                    let countryDataPhone = this.intlTelPhonenumberInput.getSelectedCountryData();
                    @this.phonenumberDialCode = countryDataPhone.dialCode;
                    @this.phonenumber = event?.detail?.employee?.phone_number;

                    this.intlTelMobilenumberInput.setDisabled(true);
                    this.intlTelPhonenumberInput.setDisabled(true);


                    setTimeout(() => {
                        // document.getElementById('firstname').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
