<div x-data="editLocation" x-cloak x-show="show" id="editLocationModal" tabindex="-1"
    x-on:show-edit-location-modal.window="showModal()" x-on:location-edited.window="edited($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    {{-- map-pin --}}
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path fill-rule="evenodd"
                            d="m11.54 22.351.07.04.028.016a.76.76 0 0 0 .723 0l.028-.015.071-.041a16.975 16.975 0 0 0 1.144-.742 19.58 19.58 0 0 0 2.683-2.282c1.944-1.99 3.963-4.98 3.963-8.827a8.25 8.25 0 0 0-16.5 0c0 3.846 2.02 6.837 3.963 8.827a19.58 19.58 0 0 0 2.682 2.282 16.975 16.975 0 0 0 1.145.742ZM12 13.5a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z"
                            clip-rule="evenodd" />
                    </svg>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-locations.modal.edit.heading')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                @if (isset($parent))
                    <button x-on:click="$dispatch('show-edit-location-modal', { location: @js($parent) })"
                        class="flex items-center font-medium text-primary-600 dark:text-primary-500 hover:underline">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M11.99 7.5 8.24 3.75m0 0L4.49 7.5m3.75-3.75v16.499h11.25" />
                        </svg>
                        <p>
                            {{ $parent->labels->{app()->getLocale()} }}
                        </p>
                    </button>
                @endif
                <div
                    class="text-sm font-medium text-center text-gray-500 border-b border-gray-200 dark:text-gray-400 dark:border-gray-700">
                    <ul class="flex flex-wrap -mb-px">
                        <li class="me-2" x-on:click="tab = 'main'">
                            <button type="button"
                                :class="{
                                    'hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300 border-transparent': tab !=
                                        'main',
                                    'active text-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500': tab ==
                                        'main'
                                }"
                                class="inline-block p-4 border-b-2 rounded-t-lg">
                                @lang('visitor-management::visit-locations.tab.main')
                            </button>
                        </li>
                        <li class="me-2" x-on:click="tab = 'sublocations'">
                            <button type="button"
                                :class="{
                                    'hover:text-gray-600 hover:border-gray-300 dark:hover:text-gray-300 border-transparent': tab !=
                                        'sublocations',
                                    'active text-primary-600 border-primary-600 dark:text-primary-500 dark:border-primary-500': tab ==
                                        'sublocations'
                                }"
                                class="inline-block p-4 border-b-2 rounded-t-lg" aria-current="page">
                                <div>
                                    @lang('visitor-management::visit-locations.tab.sub-locations')
                                    <span
                                        class="items-center inline px-2 py-1 text-sm font-medium rounded text-primary-800 bg-primary-100 dark:bg-primary-900 dark:text-primary-300">
                                        {{ count($sublocations) }}
                                    </span>
                                </div>
                            </button>
                        </li>
                    </ul>
                </div>
                <div x-show="tab == 'main'" class="pt-4">
                    <div class="grid gap-4 mb-4 sm:grid-cols-2">
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="label" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('globals::global.label.label')
                                    <x-global-components::global.input-required-hint />
                                </label>
                            </div>
                            <x-visitor-management::global.input-multi-language-json :labelsJson="$labelsJson" target="edit" />
                            <x-input-error for="labelsJson" />
                        </div>
                        <div>
                            <label for="location_type_id"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-locations.label.location-type')
                                <x-global-components::global.input-required-hint />
                            </label>
                            <select :disabled="editSucceeded" wire:model="location_type_id" id="location_type_id"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-locations.placeholder.location-type')" required="">
                                <option>
                                    @lang('globals::global.select-option.empty')
                                </option>
                                @foreach ($locationTypes as $locationType)
                                    <option value="{{ $locationType->id }}">
                                        {{ $locationType->identifier }}
                                    </option>
                                @endforeach
                            </select>
                            <x-input-error for="location_type_id" />
                        </div>
                        <div>
                            <label for="parent_location_id"
                                class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                @lang('visitor-management::visit-locations.label.parent-location')
                                <x-global-components::global.input-required-hint />
                            </label>
                            <select disabled wire:model="parent_location_id" id="parent_location_id"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-locations.placeholder.parent-location')" required="">
                                <option>
                                    @lang('globals::global.select-option.empty')
                                </option>
                                @foreach ($locations as $location)
                                    <option value="{{ $location->id }}">
                                        {{ $location->labels->{app()->getLocale()} }}
                                    </option>
                                @endforeach
                            </select>
                            <x-input-error for="parent_location_id" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="city" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-locations.label.city')
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editLocation" type="text"
                                wire:model="city" id="city"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-locations.placeholder.city')" required="">
                            <x-input-error for="city" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="postcode" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-locations.label.zip-code')
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editLocation" type="text"
                                wire:model="postcode" id="postcode"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-locations.placeholder.zip-code')" required="">
                            <x-input-error for="postcode" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="street" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-locations.label.street')
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editLocation" type="text"
                                wire:model="street" id="street"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-locations.placeholder.street')" required="">
                            <x-input-error for="street" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="housenumber"
                                    class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-locations.label.house-number')
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editLocation" type="text"
                                wire:model="housenumber" id="housenumber"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-locations.placeholder.house-number')" required="">
                            <x-input-error for="housenumber" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="email" class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('globals::global.label.email')
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editLocation" type="text"
                                wire:model="email" id="email"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('globals::global.placeholder.email')" required="">
                            <x-input-error for="email" />
                        </div>
                        <div>
                            <div class="flex items-center mb-2 space-x-1">
                                <label for="phonenumber"
                                    class="block text-sm font-medium text-gray-900 dark:text-white">
                                    @lang('visitor-management::visit-locations.label.phone-number')
                                </label>
                            </div>
                            <input :disabled="editSucceeded" @keyup.enter="$wire.editLocation" type="text"
                                wire:model="phonenumber" id="phonenumber"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-locations.placeholder.phone-number')" required="">
                            <x-input-error for="phonenumber" />
                        </div>
                    </div>
                    <div class="flex justify-end">
                        <button wire:loading.remove wire:target="editLocation" wire:click="editLocation"
                            type="button"
                            class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="w-5 h-5 mr-1 -ml-1">
                                <path fill-rule="evenodd"
                                    d="M19.916 4.626a.75.75 0 0 1 .208 1.04l-9 13.5a.75.75 0 0 1-1.154.114l-6-6a.75.75 0 0 1 1.06-1.06l5.353 5.353 8.493-12.74a.75.75 0 0 1 1.04-.207Z"
                                    clip-rule="evenodd" />
                            </svg>
                            @lang('globals::global.action.save')
                        </button>
                        <x-global-components::global.loading-spinner wire:loading wire:target="editLocation" />
                    </div>
                </div>
                <div x-show="tab == 'sublocations'" class="pt-4">
                    <div class="grid grid-cols-1 gap-2 lg:grid-cols-2">
                        @forelse ($sublocations as $sublocation)
                            <button type="button"
                                x-on:click="$dispatch('show-edit-location-modal', {location: @js($sublocation) })"
                                class="block max-w-sm p-6 bg-white border border-gray-200 rounded-lg shadow hover:bg-gray-100 dark:bg-gray-800 dark:border-gray-700 dark:hover:bg-gray-700">
                                <div class="flex items-center justify-center mb-2 space-x-2">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                        class="size-5">
                                        <path fill-rule="evenodd"
                                            d="m11.54 22.351.07.04.028.016a.76.76 0 0 0 .723 0l.028-.015.071-.041a16.975 16.975 0 0 0 1.144-.742 19.58 19.58 0 0 0 2.683-2.282c1.944-1.99 3.963-4.98 3.963-8.827a8.25 8.25 0 0 0-16.5 0c0 3.846 2.02 6.837 3.963 8.827a19.58 19.58 0 0 0 2.682 2.282 16.975 16.975 0 0 0 1.145.742ZM12 13.5a3 3 0 1 0 0-6 3 3 0 0 0 0 6Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                    <h5 class="text-xl font-bold tracking-tight text-gray-900 dark:text-white">
                                        {{ $sublocation->labels->{app()->getLocale()} }}
                                    </h5>
                                </div>
                                <p class="font-normal text-gray-700 dark:text-gray-400">
                                    {{ $sublocation->city ?? 'N/A' }}, {{ $sublocation->postcode ?? 'N/A' }}
                                </p>
                                <p class="font-normal text-gray-700 dark:text-gray-400">
                                    {{ $sublocation->street ?? 'N/A' }}, {{ $sublocation->housenumber ?? 'N/A' }}
                                </p>
                            </button>
                        @empty
                            <div class="flex items-center justify-center col-span-2">
                                @lang('visitor-management::visit-locations.info.not-found-sub-locations')
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('editLocation', () => ({
                show: false,
                tab: 'main',
                editSucceeded: false,

                edited(event) {
                    this.editSucceeded = true;
                    this.hideModal();
                },
                resetModal() {
                    this.editSucceeded = false;

                    @this.resetModal()
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(id) {
                    this.show = true;
                    this.tab = 'main';

                    setTimeout(() => {
                        // document.getElementById('label').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
