<div x-data="addOpeningHoursException" x-cloak x-show="show" id="addOpeningHoursExceptionModal" tabindex="-1"
    x-on:show-add-opening-hours-exception-modal.window="showModal()"
    x-on:opening-hours-exceptions-edited.window="edited($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-4xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    <svg class="size-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                        <path fill-rule="evenodd"
                            d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                            clip-rule="evenodd" />
                    </svg>
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('visitor-management::visit-opening-hours.add_exception')
                    </h3>
                </div>
                <button x-on:click="hideModal()" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div class="grid grid-cols-3 items-center gap-4" x-data="{ isOpen: @entangle('isOpen') }">
                    <div>
                        <label for="visitType" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('visitor-management::visit-types.visit_type')
                        </label>
                        <div wire:ignore>
                            <select wire:model="visitTypeId" id="visitType"
                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-500 focus:border-primary-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('visitor-management::visit-types.visit_type')" required="">
                                <option>-</option>
                                @foreach ($visitTypes as $visitType)
                                    <option value="{{ $visitType->id }}">
                                        @lang('visitor-management::visit-types.' . $visitType->identifier)
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <x-input-error for="visitTypeId" />
                    </div>
                    <div class="col-start-1">
                        <div wire:ignore>
                            <input type="text" readonly="readonly" wire:model="date" id="exception-date"
                                class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500">
                        </div>
                    </div>
                    <div class="flex items-center justify-center">
                        <label class="inline-flex items-center cursor-pointer">
                            <input type="checkbox" class="sr-only peer" wire:model="isOpen">
                            <div
                                class="relative w-11 h-6 bg-red-500 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-green-300 dark:peer-focus:ring-green-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-green-600 dark:peer-checked:bg-green-600">
                            </div>
                            <span x-show="isOpen" class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::visit-opening-hours.opened')
                            </span>
                            <span x-show="!isOpen" class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                @lang('visitor-management::visit-opening-hours.closed')
                            </span>
                        </label>
                    </div>
                    <div class="flex justify-center" x-show="isOpen">
                        <div wire:ignore>
                            <input type="time" wire:model="startTime" id="startTime"
                                class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('global.start_time')">
                        </div>
                        <p class="mx-2 flex items-center">
                            @lang('visitor-management::visit-opening-hours.until')
                        </p>
                        <div wire:ignore>
                            <input type="time" wire:model="endTime" id="endTime"
                                class="flatpickr-input bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                                placeholder="@lang('global.end_time')">
                        </div>
                    </div>
                </div>
                <div class="flex justify-end mt-4">
                    <button wire:click="save"
                        class="inline-flex items-center px-3 py-2 text-sm font-medium text-center text-white bg-primary-700 rounded-lg hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        @lang('globals::global.action.save')
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('addOpeningHoursException', () => ({
                show: false,
                editSucceeded: false,
                flatpickrDate: null,
                flatpickrStartTime: null,
                flatpickrEndTime: null,

                init() {
                    this.flatpickrDate = flatpickr("#exception-date", {
                        locale: @js(app()->getLocale()),
                        dateFormat: "Y-m-d",
                        altInput: true,
                        altFormat: @js(__('globals::global.date.format')),
                        defaultDate: @js(\Carbon\Carbon::now()->toDateString())
                    });
                    this.flatpickrStartTime = flatpickr("#startTime", {
                        llocale: @js(app()->getLocale()),
                        altInput: true,
                        altFormat: "H:i",
                        enableTime: true,
                        noCalendar: true,
                        dateFormat: "H:i",
                        time_24hr: true,
                        defaultDate: @js(\Carbon\Carbon::now()->toTimeString())
                    });
                    this.flatpickrEndTime = flatpickr("#endTime", {
                        locale: @js(app()->getLocale()),
                        altInput: true,
                        altFormat: "H:i",
                        enableTime: true,
                        noCalendar: true,
                        dateFormat: "H:i",
                        time_24hr: true,
                        defaultDate: '23:59:00',
                    });
                },

                edited(event) {
                    this.editSucceeded = true;
                    this.hideModal();

                    this.flatpickrDate.setDate(Date.now(), true)
                    this.flatpickrStartTime.setDate(Date.now(), true)
                    this.flatpickrEndTime.setDate('23:59:00', true)
                },
                resetModal() {
                    this.editSucceeded = false;

                    @this.resetModal()
                },
                hideModal() {
                    this.show = false;
                    this.resetModal();
                },
                showModal(id) {
                    this.show = true;

                    setTimeout(() => {
                        // document.getElementById('label').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
