<?php
/**
 * Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Actions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Actions\VisitAppointment;


use BplanModules\VisitorManagement\Enums\ProcessStatus;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use Carbon\Carbon;


/**
 * Finalisiert alle Termine, deren Endzeitpunkt in der Vergangenheit liegt
 *
 * Diese Action sollte nur einmalig, kurz nach Mitternacht, ausgeführt werden.
 * Außerdem sollte sie erst dann starten, wenn der Prozess "CheckOutOpenAppointments"
 * beendet ist.
 *
 * @version     1.4.0 / 2025-03-22
 * @history     Finish, 1.0.0 / 2024-10-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class FinishPast
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Finalisiert alle Termine, deren Endzeitpunkt in der Vergangenheit liegt
     *
     * @return      int Liefert die Anzahl der betroffenen Datensätze.
     *
     * @version     1.5.0 / 2025-03-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(): int
    {
        $Now = Carbon::now();
        $TodayEnd   = $Now->copy()->endOfDay();

        return VisitAppointment::where('process_status', '<', ProcessStatus::Finished->value)
            ->where('valid_until', '<=', $Now)
            ->update([
                'finished_at' => $Now,
                'process_status' => ProcessStatus::Finished->value,
            ]
        );
    } // execute()


} // class FinishPast {}
