<?php
/**
 * Mail Channel Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Mail
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Channels;


use BplanModules\VisitorManagement\Mail\PHPMailer;
use Illuminate\Notifications\Notification;


/**
 * Mail Channel Class
 *
 * @version     1.0.0 / 2024-11-30
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PHPMailerChannel
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */

    /**
     * @var         PHPMailer $_Mailer
     */
    protected $_Mailer;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct()
    {
        $this->_Mailer = new PHPMailer(true);

    } // __construct()


    /**
     * Send the given notification.
     *
     * @param       mixed $notifiable
     *
     * @param       \Illuminate\Notifications\Notification $notification
     *
     * @return      bool
     *
     * @version     1.0.0 / 2024-11-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function send(mixed $Notifiable, Notification $Notification): bool
    {
        $Message = $Notification->toPHPMailer($Notifiable);

        if (($from = $Message->getFrom()) !== null) {
            $this->_Mailer->setFrom($from['email'], $from['name']);
        }
        foreach ($Message->getRecipients() as $recipient) {
            $this->_Mailer->addAddress($recipient['email'], $recipient['name']);
        }
        foreach ($Message->getCcRecipients() as $recipient) {
            $this->_Mailer->addCC($recipient['email'], $recipient['name']);
        }
        foreach ($Message->getBccRecipients() as $recipient) {
            $this->_Mailer->addBCC($recipient['email'], $recipient['name']);
        }
        foreach ($Message->getReplyTo() as $recipient) {
            $this->_Mailer->addReplyTo($recipient['email'], $recipient['name']);
        }
        foreach ($Message->getAttachments() as $attachment) {
            $this->_Mailer->addAttachment($attachment['file'], $attachment['name']);
        }
        $this->_Mailer->isHTML(true);

        $this->_Mailer->AltBody = $Message->getAltBody();
        $this->_Mailer->Body = $Message->getBody();
        $this->_Mailer->Ical = $Message->getIcal();
        $this->_Mailer->Subject = $Message->getSubject();

        return $this->_Mailer->send();

    } // send()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PHPMailerChannel {}
