<?php
/**
 * Command Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Commands
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Console\Commands;


use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Repositories\VisitAppointmentRepository;
use BplanModules\VisitorManagement\Services\VisitAppointmentService;
use BplanModules\VisitorManagement\Services\VisitVisitorService;
use Carbon\Carbon;
use Illuminate\Console\Command;


/**
 * Anonymisiert alle Besucher die innerhalb eines konfigurierten Zeitraums nicht in einem Termin verwendet wurden
 *
 * @version     1.0.0 / 2025-03-22
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class AnonymizeVisitors extends Command
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $description
     */
    protected $description = 'Visitor anonymizer';


    /**
     * @var     string $signature
     */
    protected $signature = 'anonymize:visitors';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-03-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function handle()
    {
        $this->output->title('Starting');
        $this->output->info('Anonymizing visitors.');
        /*
        **  Basis-Query erstellen, mit der nur Besucher zu den Terminen ermittelt werden
        **  die vor dem konfigurierten Zeitpunkt bereits zuende waren. */
        $Query = VisitAppointment::where('valid_until', '<', Carbon::now()
            ->subDays(config('globals.anonymization-threshold-days')
        ));
        $visitorIds = VisitAppointmentRepository::getVisitorIds(Query: $Query);

        $VisitorService = new VisitVisitorService();

        $count = $VisitorService->anonymizeVisitors($visitorIds);

        $AppointmentService = new VisitAppointmentService();
        /*
        **  Die Besucher werden auch bei allen Bulk-Visits anonymisiert. */
        $this->output->info('Processing bulk appointments.');
        $count += $AppointmentService->anonymizeBulkVisitors($visitorIds);
        /*
        **  Abschließend werden noch die Gruppenbesucher zu den ermittelten Appointments
        **  anonymisiert. */
        $Appointments = $Query->get();

        $this->output->info('Processing group visits.');

        $count += $AppointmentService->anonymizeGroupVisitors($Appointments);

        $this->output->success('Anonymized '.$count.' visitor(s).');

    } // handle()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class AnonymizeVisitors extends Command {}
