<?php
/**
 * Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Enums;


/**
 * Enum Class
 *
 * @version     4.0.0 / 2024-11-16
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
enum TokenPrefix: string {

    case Appointment = 'A';
    /*
    **  Präfix für die Token der EntryPoints. */
    case EntryPoint  = 'EP';
    /*
    **  Unterscheidungskriterium, das vom Terminal vor jede Auftragsnummer gesetzt
    **  wird. Das Backend entfernt das Präfix um die korrekte Auftragsnummer zu
    **  erhalten. */
    case OrderNumber = 'O';
    /*
    **  Token das in Links verwendet werden kann (zum Beispiel für den Link zum
    **  Personalisierungformular. */
    case Web         = 'W';

} // enum TokenPrefix {}
