<?php
/**
 * Procedure Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Procedures
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

declare(strict_types=1);

namespace BplanModules\VisitorManagement\Http\Procedures;


use BplanComponents\LaravelSpryng\Notifications\SmsClient;
use BplanComponents\LaravelSpryng\Notifications\SmsMessage;
use Exception;
use Sajya\Server\Annotations\Param;
use Sajya\Server\Annotations\Result;
use Sajya\Server\Http\Request;
use Sajya\Server\Procedure;


/**
 * Procedure Class
 *
 * @version     1.3.0 / 2025-02-20
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PhoneNumberVerificationProcedure extends Procedure
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The name of the procedure that is used for referencing.
     *
     * @var     string
     */
    public static string $name = 'phonenumberverification';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Send a SMS with a verification code
     *
     * @Param(name="mobilePhoneNumber", value="required|string")
     *
     * @Result(name="success",          value="required|boolean")
     * @Result(name="verificationCode", value="required|integer")
     *
     * @param       Request $Request
     *
     * @return      array
     *
     * @version     1.3.0 / 2025-02-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function verify(Request $Request): array
    {
        $requestParams = $Request->getParams()->toArray();

        $randomInt = random_int(1000, 9999);

        $mobilePhoneNumber = str_replace(['+', ' '], '', trim($requestParams['mobilePhoneNumber']));

        $lang = 'en';

        $message = trans('notifications.verify-phone-number.sms.intro', [
                'verification-code' => $randomInt
            ],
            $lang
        );
        $Message = new SmsMessage($message, originator: config('project.company.short_name'), recipients: $mobilePhoneNumber);

        $Client = new SmsClient();

        try {
            $Client->send($Message);

        } catch (Exception $E) {
            $exceptionData = json_decode($E->getMessage());

            throw new Exception($exceptionData->message, $E->getCode());
        }
        return [
            'verificationCode' => $randomInt,
        ];
    } // verify()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PhoneNumberVerificationProcedure extends Procedure {}
