<?php
/**
 * JSON:API Resource Class
 *
 * @todo        Felder und Relationen auf den neuesten Stand bringen.
 *
 * @todo        Verwendung prüfen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Resources
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\JsonApi\Terminal\Appointments;


use BplanModules\VisitorManagement\Models\VisitAppointment;
use Illuminate\Http\Request;
use LaravelJsonApi\Core\Resources\JsonApiResource;


/**
 * JSON:API Resource Class
 *
 * @property    Appointment $Resource
 *
 * @version     1.5.0 / 2025-01-17
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitAppointmentResource extends JsonApiResource
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Get the resource's attributes.
     *
     * @param       Request|null $Request
     *
     * @return      iterable
     *
     * @version     1.4.0 / 2025-01-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function attributes($Request): iterable
    {
        return [
            'uuid' => $this->uuid,

            'active' => $this->resource->active,
            'createdAt' => $this->resource->created_at,
            'updatedAt' => $this->resource->updated_at,
            'deletedAt' => $this->resource->deleted_at,

            'bulkInformations' => $this->resource->bulk_informations,
            'calledInAt' => $this->resource->called_in_at,
            'checkedInAt' => $this->checked_in_at,
            'checkedOutAt' => $this->checked_out_at,
            'driveOnAreaPermitted' => $this->resource->drive_on_area_permitted,
            'enteredAt' => $this->entered_at,
            'ewsAppointmentId' => $this->resource->ews_appointment_id,
            'finishedAt' => $this->finished_at,
            'internalVisit' => $this->internal_visit,
            'licensePlateFormatted' => $this->resource->license_plate_formatted,
            'orderNumber' => $this->resource->order_number,
            'processStatus' => $this->resource->process_status,
            'requireEscort' => $this->resource->require_escort,
            'spontaneousVisit' => $this->resource->spontaneous_visit,
            'subject' => $this->resource->subject,
            'token' => $this->resource->token,
            'validFrom' => $this->resource->valid_from,
            'validUntil' => $this->resource->valid_until,
            'visitors' => $this->resource->visitors,
            'webToken' => $this->resource->web_token,
            'withMinors' => $this->resource->with_minors,
        ];
    } // attributes()


    /**
     * Get the resource's relationships.
     *
     * @param       Request|null $Request
     *
     * @return      iterable
     *
     * @version     1.3.0 / 2025-01-17
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function relationships($Request): iterable
    {
        return [
            $this->relation('appointment-status-logs'),
            $this->relation('bulk-appointment'),
            $this->relation('bulk-appointments'),
            $this->relation('check-in-entry-point'),
            $this->relation('check-out-entry-point'),
            $this->relation('create-user'),
            $this->relation('employees'),
            $this->relation('equipment-items'),
            $this->relation('loading-ramp'),
            $this->relation('main-employee', 'employee'),
            $this->relation('main-visitor', 'visitor'),
            $this->relation('organizer-employee'),
            $this->relation('visit-reason'),
        ];
    } // relationships()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitAppointmentResource extends JsonApiResource {}
