<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-18 16:14:49
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\Global\Modals;


use BplanModules\VisitorManagement\Enums\LanguageContext;
use BplanModules\VisitorManagement\Models\VisitLanguage;
use Illuminate\Database\Eloquent\Collection;
use Livewire\Attributes\On;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-18
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class MultiLanguageJson extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     */
    public array $labels = [];


    /**
     *
     */
    public int|string $languageContext = LanguageContext::Web->value;


    /**
     *
     */
    public ?Collection $languages;


    /**
     *
     */
    public bool $multiline = false;


    /**
     *
     */
    public ?string $target;


    /**
     *
     */
    public string $windowTitle = 'Labels';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function createMultiLanguageJson()
    {
        $this->validate();

        $this->dispatch('multi-language-json-created', json: $this->labels, target: $this->target);

    } // createMultiLanguageJson()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    #[On('show-multi-language-json-modal')]
    public function init(?array $labels, string $target, string $windowTitle = 'Labels')
    {
        if (isset($labels) && !empty($labels)) {
            $this->labels = $labels;
        }
        $this->target = $target;
        $this->windowTitle = $windowTitle;

    } // init()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function mount()
    {
        $this->languages = VisitLanguage::where('context', '&', $this->languageContext)->get();

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.global.modals.multi-language-json');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->labels = [];

    } // resetModal()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function rules()
    {
        $rules = [];

        foreach ($this->languages as $key => $language) {
            $rules["labels.{$language->code}"] = 'required';
        }
        return $rules;

    } // rules()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class MultiLanguageJson extends Component {}
