<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-18 16:14:49
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitAccessAuthorizations\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Services\VisitAppointmentService;
use Carbon\Carbon;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-18
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     */
    public ?VisitAppointment $accessAuthorization;


    /**
     *
     */
    protected VisitAppointmentService $appointmentService;


    /**
     *
     */
    // #[Validate('required|after:startDate')]
    public ?string $endDate;


    /**
     *
     */
    public bool $isActive = false;


    /**
     *
     */
    public ?string $licensePlate;


    /**
     *
     */
    protected LogService $logService;


    /**
     *
     */
    // #[Validate('required')]
    public ?string $startDate;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitAppointmentService $appointmentService)
    {
        $this->logService = $logService;
        $this->appointmentService = $appointmentService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function deleteAccessAuthorization()
    {
        try {
            $this->appointmentService->delete($this->accessAuthorization->id);

            $this->dispatch('access-authorization-deleted');

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Appointments/Modals/EditAccessAuthorization deleteAccessAuthorization error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when deleting access authorization. Check the logs for more information.');
        }
    } // deleteAccessAuthorization()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function editAccessAuthorization()
    {
        $this->validate([
            'startDate' => 'required',
            'endDate' => 'required|after_or_equal:startDate',
            'licensePlate' => 'required',
        ]);
        try {
            $accessAuthorization = $this->appointmentService->update($this->accessAuthorization->id, [
                'subject' => $this->licensePlate,
                'license_plate_formatted' => $this->licensePlate,
                'valid_from' => Carbon::parse($this->startDate)->startOfDay(),
                'valid_until' => Carbon::parse($this->endDate)->endOfDay(),
                'active' => $this->isActive,
            ]);
            $this->logService->log(LogLevel::Info, "Access Authorization id: {$this->accessAuthorization->id} updated by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('access-authorization-edited');

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'AccessAuthorizations/Modals/editAccessAuthorization error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing access authorization. Check the logs for more information.');
        }
    } // editAccessAuthorization()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    #[On('show-edit-access-authorization-modal')]
    public function initAppointment(VisitAppointment $accessAuthorization)
    {
        $this->accessAuthorization = $accessAuthorization;

        $this->licensePlate = $accessAuthorization->license_plate_formatted;

        $this->isActive  = $accessAuthorization->active;
        $this->startDate  = $accessAuthorization->valid_from->format('Y-m-d');
        $this->endDate  = $accessAuthorization->valid_until->format('Y-m-d');

        $this->dispatch('init-tippyjs');

    } // initAppointment()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function mount()
    {
        //
    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-access-authorizations.modals.edit');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->accessAuthorization = null;

    } // resetModal()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} //class Edit extends Component {}
