<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-18 16:14:49
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitAppointments;


use BplanModules\VisitorManagement\Enums\VisitTypeGroupIdentifier;
use BplanModules\VisitorManagement\Enums\VisitTypeIdentifier;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Models\VisitType;
use BplanModules\VisitorManagement\Repositories\VisitTypeRepository;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Url;
use Livewire\Component;
use Livewire\WithPagination;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-18
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class Index extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use WithPagination;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     */
     #[Url('id')]
    public ?int $appointmentIdToOpen;


    /**
     *
     */
    #[Url(keep: false)]
    public $filterAppointments = [];


    /**
     *
     */
    public ?string $filterEndDate;


    /**
     *
     */
    public ?string $filterStartDate;


    /**
     *
     */
    #[Url(keep: false)]
    public array $filterVisitTypeGroups = [];


    /**
     *
     */
    #[Url(keep: false)]
    public array $filterVisitTypes = [];


    /**
     *
     */
    protected $listeners = [
        'appointment-created' => 'render',
        'appointment-edited' => 'render',
        'appointment-deleted' => 'render',
    ];


    /**
     *
     */
    public string $search = '';


    /**
     *
     */
    public array $visitTypeGroups = [];


    /**
     *
     */
    public ?Collection $visitTypes;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    private function getAppointments()
    {
        $appointments = VisitAppointment::whereRelation('visitType', 'visit_types.identifier', '!=', VisitTypeIdentifier::AccessAuthorization->value)
            ->whereRelation('visitType', function($query) {
                $query->whereIn('visit_types.id', $this->filterVisitTypes)
                ->whereIn('visit_group', $this->filterVisitTypeGroups);
            })
            ->whereNull('bulk_appointment_id')
            ->orderBy('id', 'DESC');

        $search = trim($this->search);
        /*
        **  Nicht jeder User ist auch Mitarbeiter. */
        if (Auth::user()->employee === null) {
            /*
            **  Nur die selbst angelegten Termine des aktuelle Users. */
            $userId = Auth::user()->id;

            $appointments->where(function ($query) use ($userId) {
                $query->where('create_user_id', $userId);
            });
        } else {
            /*
            **  Nur die selbst angelegten Termine oder die Termine bei denen der aktuelle User
            **  der verantwortliche Mitarbeiter oder der Organisator ist. */
            $employeeId = Auth::user()->employee->id;
            $userId = Auth::user()->id;

            $appointments->where(function ($query) use ($employeeId, $userId) {
                $query->where('main_employee_id', $employeeId)
                    ->orWhere('organizer_employee_id', $employeeId)
                    ->orWhere('create_user_id', $userId);
            });
        }
        if (!empty($this->filterStartDate)) {
            $startDate = Carbon::parse($this->filterStartDate)->startOfDay();
            $appointments->where('valid_from', '>=', $startDate);
        }
        if (!empty($this->filterEndDate)){
            $endDate = Carbon::parse($this->filterEndDate)->endOfDay();
            $appointments->where('valid_until', '<=', $endDate);
        }
        if (!empty($search)) {
            $appointments->where(function ($query) use ($search) {
                $query->where('subject', 'like', "%$search%")
                    ->orWhere('order_number', 'like', "%$search%")
                    ->orWhere('token', 'like', "%$search%");
            });
        }
        return $appointments->paginate(12);

    } // getAppointments()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function init()
    {
        if(isset($this->appointmentIdToOpen)) {
            $appointmentToOpen = VisitAppointment::find($this->appointmentIdToOpen);

            $this->dispatch('show-edit-appointment-modal', appointment: $appointmentToOpen);
        }
    } // init()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function mount()
    {
        $this->visitTypes = VisitTypeRepository::getAll(excludeIdentifier: VisitTypeIdentifier::AccessAuthorization->value, withInternal: true);
        $this->filterVisitTypes = $this->visitTypes->pluck('id')->toArray();

        $this->visitTypeGroups = [
            VisitTypeGroupIdentifier::Visits->value,
            VisitTypeGroupIdentifier::Logistics->value,
        ];
        $this->filterVisitTypeGroups = $this->visitTypeGroups;

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-appointments.index', [
            'appointments' => $this->getAppointments(),
        ]);
    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function updated($name, $value)
    {
        switch ($name) {
            case 'filterStartDate':
            case 'filterEndDate':
            case 'filterVisitTypes':
            case 'filterVisitTypeGroups':
            case 'search':
                $this->resetPage();
                break;

            default:
                # code...
                break;
        }
    } // updated()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Index extends Component {}
