<?php
/**
 * Livewire Component Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitAppointments\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Enums\ImportContext;
use BplanModules\VisitorManagement\Imports\GroupVisitorsImport;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithFileUploads;


/**
 * Livewire Component Class
 *
 * @version     1.1.0 / 2025-04-29
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UploadVisitors extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use WithFileUploads;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     */
    public $additionalVisitorsFile;


    /**
     *
     */
    public ?VisitAppointment $appointment;


    /**
     *
     */
    public ?string $importSuccessMessage;


    /**
     *
     */
    protected LogService $logService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService)
    {
        $this->logService = $logService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-upload-visitors-modal')]
    public function init(VisitAppointment $appointment)
    {
        $this->appointment = $appointment;

    } // init()


    /**
     *
     * @version     1.0.0 / 2025-04-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-appointments.modals.upload-visitors');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->additionalVisitorsFile = null;
        $this->importSuccessMessage = null;

        $this->resetErrorBag();

    } // resetModal()


    /**
     *
     * @version     1.1.0 / 2025-04-29
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function uploadVisitors()
    {
        try {
            if (isset($this->additionalVisitorsFile)) {
                $this->logService->log(LogLevel::Info, "Starting direct-import.");
                $import = new GroupVisitorsImport(ImportContext::Upload);
                $import->setAppointmentID($this->appointment->id);
                $result = $import->importFile($this->additionalVisitorsFile->getRealPath());
                $this->logService->log(LogLevel::Info, "Direct-Import finished.");

                $this->importSuccessMessage = trans('visitor-management::personalization.visitors_imported_successfully', ['count' => $import->getRowCountSaved()]);
                $this->dispatch('visitors-upload-finished');
            }
        } catch (\Throwable $th) {
            $this->addError('additionalVisitorsFile', trans('visitor-management::personalization.error_while_importing') . ' ' . $th->getMessage());
        }
    } // uploadVisitors()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class UploadVisitors extends Component {}
