<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:43
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitContactOptions;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitContactOption;
use BplanModules\VisitorManagement\Services\VisitContactOptionService;
use Illuminate\Database\Eloquent\Collection;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\Validate;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Index extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var Collection|null
     */
    public ?Collection $contactOptions;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var VisitContactOptionService
     */
    protected VisitContactOptionService $contactOptionService;


    /**
     *
     * @var array
     */
    protected $listeners = [
        'contact-option-created' => 'render',
        'contact-option-edited' => 'render',
        'contact-option-deleted' => 'render',
    ];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getContactOptions()
    {
        $this->contactOptions = VisitContactOption::orderBy('sort_sequence')->get();
        $sortedContactOptions = [];

        foreach ($this->contactOptions as $key => $contactOption) {
            $sortedContactOptions[$contactOption->context][] = $contactOption;
        }
        return $sortedContactOptions;

    } // _getContactOptions()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitContactOptionService $contactOptionService)
    {
        $this->logService = $logService;
        $this->contactOptionService = $contactOptionService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        //
    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-contact-options.index', [
            'sortedContactOptions' => $this->_getContactOptions(),
        ]);
    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updateContactOptionsSequence($items)
    {
        try {
            foreach($items as $item)
            {
                $this->contactOptionService->update($item['value'], [
                    'sort_sequence' => $item['order']
                ]);
            }

            $this->logService->log(LogLevel::Info, "ContactOptions Sort Sequence updated by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('contact-options-sort-sequence-updated');
            $this->banner(trans('visitor-management::visit-contact-options.updated_successfully'));
            $this->_getContactOptions();

        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'ContactOptions/Index updateContactOptionsSequence error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when updating sort sequence. Check the logs for more information.');
        }

    } // updateContactOptionsSequence()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Index extends Component {}
