<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitEmployees\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Services\VisitEmployeeService;
use BplanModules\VisitorManagement\Traits\WithLicensePlateInput;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\Validate;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Add extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;
    use WithLicensePlateInput;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var string|null
     */
    #[Validate('required|phone:INTERNATIONAL')]
    public ?string $contactGroup; // TODO LIST AUS DATENBANK - BEARBEITBAR


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $department;


    /**
     *
     * @var string|null
     */
    #[Validate('required|email:rfc,dns')]
    public ?string $email;


    /**
     *
     * @var VisitEmployeeService
     */
    protected VisitEmployeeService $employeeService;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $firstname;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $function;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $lastname;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var string|null
     */
    #[Validate('required')]
    public ?string $mobilenumber;


    /**
     *
     * @var string
     */
    public string $mobilenumberDialCode = "";


    /**
     *
     * @var string|null
     */
    #[Validate('required|phone:INTERNATIONAL')]
    public ?string $phonenumber;


    /**
     *
     * @var string
     */
    public string $phonenumberDialCode = "";


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitEmployeeService $employeeService)
    {
        $this->logService = $logService;
        $this->employeeService = $employeeService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function createEmployee()
    {
        $this->validate();

        $this->mobilenumberDialCode = "+{$this->mobilenumberDialCode}";
        $this->mobilenumber = str_replace($this->mobilenumberDialCode, '', $this->mobilenumber);
        $this->phonenumberDialCode = "+{$this->phonenumberDialCode}";
        $this->phonenumber = str_replace($this->phonenumberDialCode, '', $this->phonenumber);

        try {
            $this->employeeService->create([
                'first_name' => $this->firstname,
                'last_name' => $this->lastname,
                'email' => $this->email,
                'mobile_phone_number' => $this->mobilenumber,
                'mobile_phone_number_country_code' => $this->mobilenumberDialCode,
                'phone_number' => $this->phonenumber,
                'phone_number_country_code' => $this->mobilenumberDialCode,
                'department' => $this->department,
                'function' => $this->function,
                'contact_group' => $this->contactGroup,
                'license_plate' => implode(';', $this->licensePlates),
            ]);

            $this->logService->log(LogLevel::Info, "Employee {$this->firstname}, {$this->lastname} added by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('employee-created');
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Locations/Modals/createEmployee error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when creating employee. Check the logs for more information.');
        }
    } // createEmployee()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-employees.modals.add');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->clearLicensePlates();

        $this->firstname = null;
        $this->lastname = null;
        $this->email = null;
        $this->mobilenumber = null;
        $this->phonenumber = null;

    } // resetModal()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Add extends Component {}
