<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitTypes\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Models\VisitType;
use BplanModules\VisitorManagement\Services\VisitTypeService;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Attributes\Validate;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    // #[Validate('required')]
    // public ?bool $addPortalLink = false;
    // #[Validate('required')]
    // public ?bool $addSafetyBriefingLink = false;
    // #[Validate('required')]
    // public ?bool $addTimeSlotBookingLink = false;


    /**
     *
     * @var LogService
     */
    protected LogService $logService;


    /**
     *
     * @var array|null
     */
    public ?array $safetyBriefingsJson;


    /**
     *
     * @var VisitType|null
     */
    public ?VisitType $visitType;


    /**
     *
     * @var VisitTypeService
     */
    protected VisitTypeService $visitTypeService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitTypeService $visitTypeService)
    {
        $this->logService = $logService;
        $this->visitTypeService = $visitTypeService;

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function editVisitType()
    {
        $this->validate();

        try {
            $this->visitTypeService->update($this->visitType->id, [
                // 'add_portal_link' => $this->addPortalLink,
                // 'add_safety_briefing_link' => $this->addSafetyBriefingLink,
                // 'add_time_slot_booking_link' => $this->addTimeSlotBookingLink,
                'safety_briefings' => $this->safetyBriefingsJson,
            ]);

            $visitTypeName = trans('visitor-management::visit-types.identifier.' . $this->visitType->identifier);
            $this->logService->log(LogLevel::Info, "VisitType {$visitTypeName} edited by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('visit-type-edited');
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Locations/Modals/editVisitType error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing VisitType. Check the logs for more information.');
        }
    } // editVisitType()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-edit-visit-type-modal')]
    public function initVisitType(VisitType $visitType)
    {
        $this->visitType = $visitType;

        // $this->addPortalLink = $visitType->add_portal_link;
        // $this->addSafetyBriefingLink = $visitType->add_safety_briefing_link;
        // $this->addTimeSlotBookingLink = $visitType->add_time_slot_booking_link;
        $this->safetyBriefingsJson = (array)$visitType->safety_briefings;

    } // initVisitType()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('multi-language-json-created')]
    public function onMultiLanguageJsonCreated(?array $json, string $target)
    {
        if ($target == 'edit') {
            $this->safetyBriefingsJson = $json;
        }
    } // onMultiLanguageJsonCreated()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-types.modals.edit');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        // $this->addPortalLink = false;
        // $this->addSafetyBriefingLink = false;
        // $this->addTimeSlotBookingLink = false;
        $this->safetyBriefingsJson = null;

    } // resetModal()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Edit extends Component {}
