<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Livewire\VisitVisitors\Modals;


use BplanBase\Globals\Enums\LogLevel;
use BplanBase\Globals\Services\LogService;
use BplanModules\VisitorManagement\Enums\LanguageContext;
use BplanModules\VisitorManagement\Models\VisitLanguage;
use BplanModules\VisitorManagement\Models\VisitVisitor;
use BplanModules\VisitorManagement\Services\VisitVisitorService;
use Laravel\Jetstream\InteractsWithBanner;
use Livewire\Attributes\On;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Edit extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use InteractsWithBanner;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */

    public ?string $firstname = "";
    public ?string $lastname = "";
    public ?string $email = "";
    public ?string $mobilenumberDialCode = "";
    public ?string $mobilenumber = "";
    public ?string $company = "";
    public ?string $preferredLanguage = "";
    // #[Validate('required')]
    // public ?string $birthday;
    // #[Validate('required')]
    // public ?string $country;
    // #[Validate('required')]
    // public ?string $postcode;
    // #[Validate('required')]
    // public ?string $street;
    // #[Validate('required')]
    // public ?string $housenumber;

    public ?VisitVisitor $visitor;
    public ?array $languages = [];

    protected LogService $logService;
    protected VisitVisitorService $visitorService;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(LogService $logService, VisitVisitorService $visitorService)
    {
        $this->logService = $logService;
        $this->visitorService = $visitorService;
        $this->languages = VisitLanguage::where('context', '&', LanguageContext::Both->value)->get()->pluck('code')->toArray();

    } // boot()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleteVisitor()
    {
        try
        {
            $this->visitorService->delete($this->visitor->id);

            $this->dispatch('visitor-deleted');
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Visitors/Modals/deleteVisitor error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when deleting visitor. Check the logs for more information.');
        }
    } // deleteVisitor()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function editVisitor()
    {
        $this->validate([
            'firstname' => 'required',
            'lastname' => 'required',
            'mobilenumber' => 'sometimes|phone:INTERNATIONAL',
            'email' => "sometimes|email:rfc,dns",
            'preferredLanguage' => 'required',
        ]);

        $this->mobilenumberDialCode = "+{$this->mobilenumberDialCode}";
        $this->mobilenumber = str_replace($this->mobilenumberDialCode, '', $this->mobilenumber);

        try {
            $this->visitorService->update($this->visitor->id, [
                'first_name' => $this->firstname,
                'last_name' => $this->lastname,
                'email' => $this->email,
                'mobile_phone_number' => $this->mobilenumber,
                'mobile_phone_number_country_code' => $this->mobilenumberDialCode,
                'company' => $this->company,
                'preferred_language' => $this->preferredLanguage,
                // 'birthday' => $this->birthday,
                // 'country' => $this->country,
                // 'zip' => $this->postcode,
                // 'street' => $this->street,
                // 'housenumber' => $this->housenumber,
                // 'hasSafetyBriefing' => $this->hasSafetyBriefing,
            ]);

            $this->logService->log(LogLevel::Info, "Visitor {$this->firstname}, {$this->lastname} edited by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('visitor-edited');
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Visitors/Modals/editVisitor error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when editing visitor. Check the logs for more information.');
        }
    } // editVisitor()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('show-edit-visitor-modal')]
    public function initVisitor(VisitVisitor $visitor)
    {
        $this->visitor = $visitor;

        $this->firstname = $visitor->first_name;
        $this->lastname = $visitor->last_name;
        $this->email = $visitor->email;
        $this->mobilenumber = $visitor->mobile_phone_number;
        $this->company = $visitor->company;
        $this->preferredLanguage = $visitor->preferred_language;
        // $this->birthday = $visitor->birthday;
        // $this->country = $visitor->country;
        // $this->postcode = $visitor->zip;
        // $this->street = $visitor->street;
        // $this->housenumber = $visitor->housenumber;
        // $this->hasSafetyBriefing = $visitor->hasSafetyBriefing;

        $this->dispatch('init-tippyjs');

    } // initVisitor()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function mount()
    {
        $this->preferredLanguage = config('app.fallback_locale');

    } // mount()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('visitor-management::livewire.visit-visitors.modals.edit');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function resetModal()
    {
        $this->visitor = null;

        $this->firstname = null;
        $this->lastname = null;
        $this->email = null;
        $this->mobilenumber = null;
        $this->company = null;
        $this->preferredLanguage = config('app.fallback_locale');
        // $this->birthday = null;
        // $this->country = null;
        // $this->postcode = null;
        // $this->street = null;
        // $this->housenumber = null;
        // $this->hasSafetyBriefing = null;

    } // resetModal()


    /**
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function verifyVisitor()
    {
        try {
            $this->visitorService->update($this->visitor->id, [
                'verified' => true,
            ]);

            $this->logService->log(LogLevel::Info, "Visitor {$this->firstname}, {$this->lastname} verified by " . auth()->user()->name . ' (' . auth()->user()->email . ')');

            $this->dispatch('init-tippyjs');
            $this->dispatch('visitor-edited');
        } catch (\Throwable $th) {
            $this->logService->log(LogLevel::Error, 'Visitors/Modals/verifyVisitor error: ' . $th->getMessage() . ', file:' . $th->getFile() . ', line:' .  $th->getLine());
            $this->dangerBanner('Error when verifying visitor. Check the logs for more information.');
        }
    } // verifyVisitor()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Edit extends Component {}
