<?php
/**
 * Model Class
 *
 * Aus der automatischen Generierung genommen wegen einer individuellen Relationen-Methode.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-20 00:14:42
 * @package     bplan-modules/visitor-management
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Models;


use BplanModules\VisitorManagement\Models\VisitOpeningHourExceptions;
use BplanModules\VisitorManagement\Models\VisitOpeningHours;
use BplanModules\VisitorManagement\Observers\VisitTypeObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;
use Illuminate\Database\Eloquent\SoftDeletes;


/**
 * Model Class
 *
 * @version     1.4.0 / 2025-04-20
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([VisitTypeObserver::class])]
class VisitType extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $appends = [];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $casts = [
        'active'                     => 'boolean',
        'add_time_slot_booking_link' => 'boolean',
        'created_at'                 => 'datetime',
        'deleted_at'                 => 'datetime',
        'dependencies'               => 'object',
        'internal'                   => 'boolean',
        'safety_briefings'           => 'object',
        'updated_at'                 => 'datetime',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $fillable = [
        'active',
        'add_time_slot_booking_link',
        'dependencies',
        'identifier',
        'internal',
        'safety_briefing_valid_time',
        'safety_briefings',
        'visit_group',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'updated_at',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-04-20
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'visit_types';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Liefert alle Appointments zum VisitType über den VisitReason
     *
     * Diese Methode funktioniert auch im Kontext der JSON:API. Das heißt, es lässt sich eine
     * Relation definieren, die dann auch abgefragt werden kann.
     * Der umgekehrte Weg (Appointment::visitType()) funktioniert mit der JSON:API nicht.
     *
     * @return      HasManyThrough
     *
     * @version     1.0.0 / 2024-08-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function appointments(): HasManyThrough
    {
        return $this->hasManyThrough(Appointment::class, VisitReason::class);

    } // appointments()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function openingHourExceptions(): HasMany
    {
        return $this->hasMany(VisitOpeningHourException::class, 'visit_type_id');

    } // openingHourExceptions()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-03-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function openingHours(): HasMany
    {
        return $this->hasMany(VisitOpeningHour::class, 'visit_type_id');

    } // openingHours()


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2024-10-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function visitReasons(): HasMany
    {
        return $this->hasMany(VisitReason::class, 'visit_type_id');

    } // visitReasons()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitType extends Model {}
