<?php
/**
 * Model Class
 *
 * Aus der automatischen Generierung entfernt wegen der Notification-Methoden und
 * wegen der boot-Methode.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-21 22:26:13
 * @package     bplan-modules/visitor-management
 * @subpackage  Models
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Models;


use BplanModules\VisitorManagement\Observers\VisitVisitorObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Illuminate\Notifications\Notification;


/**
 * Model Class
 *
 * @version     1.4.0 / 2025-04-21
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
#[ObservedBy([VisitVisitorObserver::class])]
class VisitVisitor extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use Notifiable;
    use SoftDeletes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The accessors to append to the model's array form.
     *
     * @var         array<int, string> $appends
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $appends = [];


    /**
     * @var         array<string, string> $casts
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $casts = [
        'active'                    => 'boolean',
        'anonymized'                => 'boolean',
        'created_at'                => 'datetime',
        'deleted_at'                => 'datetime',
        'import_failures'           => 'object',
        'safety_briefing_confirmed' => 'datetime',
        'updated_at'                => 'datetime',
        'verified'                  => 'boolean',
    ];


    /**
     * The attributes that are mass assignable.
     *
     * @var         array<int, string> $fillable
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $fillable = [
        'active',
        'anonymized',
        'company',
        'email',
        'first_name',
        'import_failure_count',
        'import_failures',
        'last_name',
        'mobile_phone_number',
        'mobile_phone_number_country_code',
        'preferred_language',
        'safety_briefing_confirmed',
        'verified',
    ];


    /**
     * The attributes that aren't mass assignable.
     *
     * @var         array<int, string> $guarded
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $guarded = [
        'created_at',
        'deleted_at',
        'updated_at',
    ];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var         array<int, string> $hidden
     *
     * @version     1.0.0 / 2025-04-21
     */
    protected $hidden = [];


    /**
     * The table associated with the model.
     *
     * @var         string $table
     */
    protected $table = 'visit_visitors';


    /**
     * Indicates if the model should be timestamped.
     *
     * @var         bool $timestamps
     */
    public $timestamps = true;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      HasMany
     *
     * @version     1.0.0 / 2025-04-21
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function assignedAppointments(): HasMany
    {
        return $this->hasMany(VisitAppointment::class, 'main_visitor_id');

    } // assignedAppointments()


    /**
     *
     * @param       bool $reverted
     *
     * @return 	    string
     *
     * @version     2.0.0 / 2025-02-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getFullName(bool $reverted = false): string
    {
        if ($reverted === true) {
            return $this->last_name.', '.$this->first_name;
        }
        return $this->first_name.' '.$this->last_name;

    } // getFullName()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.1 / 2025-02-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPhoneNumber(): null|string
    {
        if ($this->mobile_phone_number === null) {
            return null;
        }
        return $this->mobile_phone_number_country_code.$this->mobile_phone_number;

    } // getPhoneNumber()


    /**
     * Route notifications for the mail channel.
     *
     * @param       Notification $Notification
     *
     * @return      array<string, string>|null|string
     *
     * @version     1.1.0 / 2025-03-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function routeNotificationForMail(Notification $Notification): array|null|string
    {
        if ($this->email === null) {
            return null;
        }
        return [$this->email => $this->getFullName()];

    } // routeNotificationForMail()


    /**
     * Route notifications for the Spyng SMS channel.
     *
     * @return 	    null|string
     *
     * @version     1.3.0 / 2025-03-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function routeNotificationForSpryngSms(): null|string
    {
        if ($this->mobile_phone_number === null) {
            return null;
        }
        return str_replace(['+', ' ', '/', '-'], '', $this->getPhoneNumber());

    } // routeNotificationForSpryngSms()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitVisitor extends Model {}
