<?php
/**
 * Notification Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Notifications
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Notifications;


use BplanComponents\LaravelSpryng\Notifications\SmsChannel;
use BplanComponents\LaravelSpryng\Notifications\SmsMessage;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use BplanModules\VisitorManagement\Models\VisitLocation;
use BplanModules\VisitorManagement\Repositories\VisitLocationRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;


/**
 * Notification Class
 *
 * Benachrichtigung an einen Besucher (Hauptbesucher/Logisitk) zum Anfahren der Laderampe (per SMS).
 *
 * @version     1.1.0 / 2025-01-12
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ApproachLoadingRamp extends Notification
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use Queueable;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     VisitAppointment $_Appointment
     */
    protected $_Appointment;


    /**
     * @var     VisitLocation $_LoadingRamp
     */
    protected $_LoadingRamp;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new notification instance.
     *
     * @param       VisitAppointment $Appointment
     *
     * @version     1.0.0 / 2024-11-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(VisitAppointment $Appointment)
    {
        $this->_Appointment = $Appointment;

        $this->_LoadingRamp = VisitLocationRepository::getById($this->_Appointment->loading_ramp_id);

    } // __construct()


    /**
     * Get the array representation of the notification.
     *
     * @param       object $Notifiable
     *
     * @return      array<string, mixed>
     *
     * @version     1.0.0 / 2024-11-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toArray(object $Notifiable): array
    {
        return [
            //
        ];
    } // toArray()


    /**
     *
     * @param       object $Notifiable
     *
     * @return 	    SmsMessage|string
     *
     * @version     1.1.0 / 2025-01-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toSpryngSms(object $Notifiable): SmsMessage|string
    {
        $lang = $Notifiable->preferred_language;
        $fallbackLang = config('app.fallback_locale', 'en');

        $loadingRamp = isset($this->_LoadingRamp->labels->{$lang})
            ? $this->_LoadingRamp->labels->{$lang}
            : $this->_LoadingRamp->labels->{$fallbackLang};

        $body = trans('notifications.approach-loading-ramp.sms.intro', [
                'loading-ramp' => $loadingRamp
            ],
            $lang
        );
        $SmsMessage = new SmsMessage($body);

        return $SmsMessage;

    } // toSpryngsms()


    /**
     * Get the notification's delivery channels.
     *
     * @param       object $Notifiable
     *
     * @return      array<int, string>
     *
     * @version     1.0.0 / 2024-11-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function via(object $Notifiable): array
    {
        return [
            SmsChannel::class,
        ];
    } // via()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ApproachLoadingRamp extends Notification {}
