<?php
/**
 * Notification Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Notifications
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Notifications;


use BplanComponents\LaravelSpryng\Notifications\SmsChannel;
use BplanComponents\LaravelSpryng\Notifications\SmsMessage;
use BplanModules\VisitorManagement\Models\VisitAppointment;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;


/**
 * Notification Class
 *
 * Benachrichtigung an die Logistik über die Ankunft eines Besuchers (per E-Mail und SMS).
 *
 * @version     1.2.0 / 2025-01-12
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class LogisticsVisitorArrived extends Notification
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

    use Queueable;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     VisitAppointment $_Appointment
     */
    private $_Appointment;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new notification instance.
     *
     * @param       VisitAppointment $Appointment
     *
     * @version     1.0.0 / 2024-11-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(VisitAppointment $Appointment)
    {
        $this->_Appointment = $Appointment;

    } // __construct()


    /**
     * Get the array representation of the notification.
     *
     * @param       object $Notifiable
     *
     * @return      array<string, mixed>
     *
     * @version     1.0.0 / 2024-11-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toArray(object $Notifiable): array
    {
        return [
            //
        ];
    } // toArray()


    /**
     * Get the mail representation of the notification.
     *
     * @param       object $Notifiable
     *
     * @throws      Exception
     *
     * @return      MailMessage
     *
     * @version     1.2.0 / 2025-01-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toMail(object $Notifiable): MailMessage
    {
        $lang = config('visitor-management.loading-bay.notification-language');

        $lc_logisitcQueue = trans('navigation.logistic-queue', [], $lang);

        $lc_button = trans('notifications.logistics-visitor-arrived.mail.button.view', [], $lang);
        $lc_greeting = trans('notifications.greeting', [], $lang);
        $lc_subject = trans('notifications.logistics-visitor-arrived.mail.subject', [], $lang);
        $lc_intro = trans('notifications.logistics-visitor-arrived.mail.intro', [
                'button' => $lc_button,
                'logistic-queue' => $lc_logisitcQueue,
                'token' => $this->_Appointment->token

            ], $lang
        );
        $MailMessage = (new MailMessage)
            ->subject($lc_subject)
            ->greeting($lc_greeting)
            ->line($lc_intro)->action($lc_button, route('visit-logistic-queue.index', [
                    'id' => $this->_Appointment->id
                ]
            )
        );
        return $MailMessage;

    } // toMail()


    /**
     *
     * @param       object $Notifiable
     *
     * @return 	    SmsMessage|string
     *
     * @version     1.1.0 / 2025-01-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toSpryngSms(object $Notifiable): SmsMessage|string
    {
        $lang = config('visitor-management.loading-bay.notification-language');

        $body = trans('notifications.logistics-visitor-arrived.sms.intro', [
                'token' => $this->_Appointment->token
            ], $lang
        );
        $SmsMessage = new SmsMessage($body);

        return $SmsMessage;

    } // toSpryngsms()


    /**
     * Get the notification's delivery channels.
     *
     * @param       object $Notifiable
     *
     * @return      array<int, string>
     *
     * @version     1.0.0 / 2024-11-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function via(object $Notifiable): array
    {
        return [
            'mail',
            SmsChannel::class,
        ];
    } // via()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class LogisticsVisitorArrived extends Notification {}
