<?php
/**
 * Observer Class
 *
 * Aus der automatischen Erzeugung genommen wegen der individuellen Anpassung der
 * creating- und der updating-Methode.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-20 10:45:32
 * @package     bplan-modules/visitor-management
 * @subpackage  Observers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Observers;


use BplanModules\VisitorManagement\Models\VisitEmployee;
use BplanBase\Globals\Helpers\StringHelper;


/**
 * Observer Class
 *
 * @version     1.1.0 / 2025-04-20
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitEmployeeObserver
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string MODEL_CLASS
     */
    const MODEL_CLASS = VisitEmployee::class;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Handle the Models "created" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function created(VisitEmployee $Model): void
    {
        //
    } // created()


    /**
     * Handle the Models "creating" event
     *
     * When a new model is saved for the first time, the creating and created
     * events will dispatch.
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function creating(VisitEmployee $Model): void
    {
        if (!empty($Model->mobile_phone_number_country_code)) {
            $phoneNumber = $Model->mobile_phone_number_country_code.$Model->mobile_phone_number;
        } else {
            $phoneNumber = $Model->mobile_phone_number;
        }
        $mobilePhoneNumber = StringHelper::explodePhoneNumber(StringHelper::normalizePhoneNumber($phoneNumber));

        if (!empty($Model->phone_number_country_code)) {
            $phoneNumber = $Model->phone_number_country_code.$Model->phone_number;
        } else {
            $phoneNumber = $Model->phone_number;
        }
        $phoneNumber = StringHelper::explodePhoneNumber(StringHelper::normalizePhoneNumber($phoneNumber));

        $Model->email = StringHelper::normalizeEmail($Model->email);
        $Model->mobile_phone_number = $mobilePhoneNumber['phone-number'];
        $Model->mobile_phone_number_country_code = $mobilePhoneNumber['country-code'];
        $Model->phone_number = $phoneNumber['phone-number'];
        $Model->phone_number_country_code = $phoneNumber['country-code'];

    } // creating()


    /**
     * Handle the Models "deleted" event
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleted(VisitEmployee $Model): void
    {
        //
    } // deleted()


    /**
     * Handle the Models "deleting" event
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function deleting(VisitEmployee $Model): void
    {
        //
    } // deleting()


    /**
     * Handle the Models "forceDeleted" event
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleted(VisitEmployee $Model): void
    {
        //
    } // forceDeleted()


    /**
     * Handle the Models "forceDeleting" event
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function forceDeleting(VisitEmployee $Model): void
    {
        //
    } // forceDeleting()


    /**
     * Handle the Models "replicating" event
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function replicating(VisitEmployee $Model): void
    {
        //
    } // replicating()


    /**
     * Handle the Models "restored" event
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restored(VisitEmployee $Model): void
    {
        //
    } // restored()


    /**
     * Handle the Models "restoring" event
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function restoring(VisitEmployee $Model): void
    {
        //
    } // restoring()


    /**
     * Handle the Models "retrieved" event
     *
     * The retrieved event will dispatch when an existing model is retrieved
     * from the database.
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function retrieved(VisitEmployee $Model): void
    {
        //
    } // retrieved()


    /**
     * Handle the Models "saved" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saved(VisitEmployee $Model): void
    {
        //
    } // saved()


    /**
     * Handle the Models "saving" event
     *
     * The saving / saved events will dispatch when a model is created or
     * updated - even if the model's attributes have not been changed.
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saving(VisitEmployee $Model): void
    {
        //
    } // saving()


    /**
     * Handle the Models "trashed" event
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function trashed(VisitEmployee $Model): void
    {
        //
    } // trashed()


    /**
     * Handle the Models "updated" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updated(VisitEmployee $Model): void
    {
        //
    } // updated()


    /**
     * Handle the Models "updating" event
     *
     * The updating / updated events will dispatch when an existing model is
     * modified and the save method is called.
     *
     * @param       VisitEmployee $Model
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-04-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updating(VisitEmployee $Model): void
    {
        if (!empty($Model->mobile_phone_number_country_code)) {
            $phoneNumber = $Model->mobile_phone_number_country_code.$Model->mobile_phone_number;
        } else {
            $phoneNumber = $Model->mobile_phone_number;
        }
        $mobilePhoneNumber = StringHelper::explodePhoneNumber(StringHelper::normalizePhoneNumber($phoneNumber));

        if (!empty($Model->phone_number_country_code)) {
            $phoneNumber = $Model->phone_number_country_code.$Employee->phone_number;
        } else {
            $phoneNumber = $Model->phone_number;
        }
        $phoneNumber = StringHelper::explodePhoneNumber(StringHelper::normalizePhoneNumber($phoneNumber));

        $Model->email = StringHelper::normalizeEmail($Model->email);
        $Model->mobile_phone_number = $mobilePhoneNumber['phone-number'];
        $Model->mobile_phone_number_country_code = $mobilePhoneNumber['country-code'];
        $Model->phone_number = $phoneNumber['phone-number'];
        $Model->phone_number_country_code = $phoneNumber['country-code'];

    } // updating()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitEmployeeObserver {}
