<?php
/**
 * Service Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:42
 * @package     bplan-modules/visitor-management
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Services;


use BplanModules\VisitorManagement\Actions\VisitAppointmentEquipmentItem\Create;
use BplanModules\VisitorManagement\Actions\VisitAppointmentEquipmentItem\Delete;
use BplanModules\VisitorManagement\Actions\VisitAppointmentEquipmentItem\Update;
use BplanModules\VisitorManagement\Models\VisitAppointmentEquipmentItem;
use BplanModules\VisitorManagement\Repositories\VisitAppointmentEquipmentItemRepository;


/**
 * Service Class
 *
 * @version     1.1.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitAppointmentEquipmentItemService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Erzeugt, aktualisiert oder löscht eine AppointmentEquipmentItem-Verknüpfung
     *
     * Die Löschung erfolgt wenn der Schlüssel "amount" in den $attributes empty ist. Andernfalls wird eine neue
     * Verknüpfung angelegt oder - sofern vorhanden - die bestehende Verknüpfung aktualisiert.
     *
     * @param       array $attributes
     *
     * @param       null|string $appointment_id
     *              Wenn eine gesonderte $appointment_id übergeben wird, dann wird diese für die Suche
     *              in der Datenbank verwendet und zusätzlich auch in $attributes abgelegt. Wird keine
     *              $appointment_id übergeben wird, dann wird davon ausgegangen, dass es einen entsprechenden
     *              Schlüssel/Wert in $attributes gibt.
     *
     * @return      VisitAppointmentEquipmentItem|null Liefert das AppointmentEquipmentItem-Objekt oder NULL, wenn
     *              es kein Objekt gibt. Dieser Fall kann eintreten, wenn es zu den übergebenen Daten keinen
     *              entsprechenden Datensatz gibt und der Schlüssel "amount" nicht in $attributes enthalten
     *              oder leer (null, 0) ist.
     *
     * @version     1.0.1 / 2024-10-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saveOrDelete(array $attributes, null|string $appointment_id = null): VisitAppointmentEquipmentItem|null
    {
        if ($appointment_id === null) {
            $appointment_id = $attributes['appointment_id'];
        } else {
            $attributes['appointment_id'] = $appointment_id;
        }
        if (($id = VisitAppointmentEquipmentItemRepository::isLinked($appointment_id, $attributes['equipment_item_id'])) !== false) {
            if (empty($attributes['amount'])) {
                $Action = new Delete();

                return $Action->execute($id);

            } else {
                $Action = new Update();

                return $Action->execute($id, $attributes);
            }
        }
        if (empty($attributes['amount'])) {
            return null;
        }
        $Action = new Create();

        return $Action->execute($attributes);

    } // saveOrDelete()


    /**
     *
     * @param       array $attributeCollection
     *              Ein mehrdimensionaler Array.
     *
     * @param       null|string $appointment_id
     *              Wenn eine gesonderte $appointment_id übergeben wird, dann wird diese für die Suche
     *              in der Datenbank verwendet und zusätzlich auch in $attributes abgelegt. Wird keine
     *              $appointment_id übergeben wird, dann wird davon ausgegangen, dass es einen entsprechenden
     *              Schlüssel/Wert in $attributes gibt.
     *
     * @return 	    array Gibt einen Array mit den AppointmentEquipmentItem-Objekten zu den betroffenden Datensätzen zurück.
     *
     * @version     1.0.0 / 2024-10-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function saveOrDeleteMultiple(array $attributeCollection, null|string $appointment_id = null): array
    {
        $return = [];

        foreach ($attributeCollection as $attributes) {
            $AppointmentEquipmentItem = $this->saveOrDelete($attributes, $appointment_id);

            if ($AppointmentEquipmentItem !== null) {
                $return[] = $AppointmentEquipmentItem;
            }
        }
        return $return;

    } // saveOrDeleteMultiple()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitAppointmentEquipmentItemService {}
