<?php
/**
 * Service Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:43
 * @package     bplan-modules/visitor-management
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Services;


use App\Models\User;
use BplanModules\VisitorManagement\Actions\VisitEmployee\Create;
use BplanModules\VisitorManagement\Actions\VisitEmployee\Delete;
use BplanModules\VisitorManagement\Actions\VisitEmployee\UnlinkUser;
use BplanModules\VisitorManagement\Actions\VisitEmployee\Update;
use BplanModules\VisitorManagement\Models\VisitEmployee;


/**
 * Service Class
 *
 * @version     1.1.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitEmployeeService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return      VisitEmployee
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(array $attributes): VisitEmployee
    {
        $Action = new Create();

        return $Action->execute($attributes);

    } // create()


    /**
     *
     * @param       int|string|VisitEmployee $visitEmployee
     *
     * @return      VisitEmployee
     *
     * @version     2.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(int|string|VisitEmployee $visitEmployee): VisitEmployee
    {
        $Action = new Delete();

        return $Action->execute($visitEmployee);

    } // delete()


    /**
     *
     * @param       int|string|VisitEmployee|User $subject
     *              Muss entweder die ID eines Employees oder ein Objekt vom Typ Employee
     *              oder User sein.
     *
     * @return      int
     *
     * @version     1.0.0 / 2025-01-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function unlinkUser(int|string|VisitEmployee|User $subject): int
    {
        $Action = new UnlinkUser();

        return $Action->execute($subject);

    } // unlinkUser()


    /**
     *
     * @param       int|string|VisitEmployee $visitEmployee
     *
     * @param       array $attributes
     *
     * @return      VisitEmployee
     *
     * @version     2.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(int|string|VisitEmployee $visitEmployee, array $attributes): VisitEmployee
    {
        $Action = new Update();

        return $Action->execute($visitEmployee, $attributes);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitEmployeeService {}
