<?php
/**
 * Service Class
 *
 * Wegen individueller Anpassungen aus der automatischen Generierung genommen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-04-13 18:30:45
 * @package     bplan-modules/visitor-management
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Services;


use BplanModules\VisitorManagement\Actions\VisitVisitor\AnonymizeVisitors;
use BplanModules\VisitorManagement\Actions\VisitVisitor\Create;
use BplanModules\VisitorManagement\Actions\VisitVisitor\Delete;
use BplanModules\VisitorManagement\Actions\VisitVisitor\Update;
use BplanModules\VisitorManagement\Models\VisitVisitor;
use Carbon\Carbon;


/**
 * Service Class
 *
 * @version     1.1.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitVisitorService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Anonymisiert die Besucher mit den übergebenen IDs
     *
     * @param       array $visitorIds
     *
     * @return      int
     *
     * @version     1.0.0 / 2025-03-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function anonymizeVisitors(array $visitorIds): int
    {
        $Action = new AnonymizeVisitors();

        return $Action->execute($visitorIds);

    } // anonymizeVisitors()


    /**
     *
     * @param       array $attributes
     *
     * @return      VisitVisitor
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(array $attributes): VisitVisitor
    {
        $Action = new Create();

        return $Action->execute($attributes);

    } // create()


    /**
     *
     * @param       int|string|VisitVisitor $visitVisitor
     *
     * @return      VisitVisitor
     *
     * @version     2.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(int|string|VisitVisitor $visitVisitor): VisitVisitor
    {
        $Action = new Delete();

        return $Action->execute($visitVisitor);

    } // delete()


    /**
     *
     * @param       int|string|VisitVisitor $visitor
     *
     * @param       array $attributes
     *
     * @return      VisitVisitor
     *
     * @version     1.0.0 / 2024-12-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setSafetyBriefingConfirmed(int|string|VisitVisitor $visitor): VisitVisitor
    {
        $Action = new Update();

        return $Action->execute($visitor, [
            'safety_briefing_confirmed' => Carbon::now(),
        ]);

    } // setSafetyBriefingConfirmed()


    /**
     *
     * @param       int|string|VisitVisitor $visitVisitor
     *
     * @param       array $attributes
     *
     * @return      VisitVisitor
     *
     * @version     2.0.0 / 2025-04-13
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(int|string|VisitVisitor $visitVisitor, array $attributes): VisitVisitor
    {
        $Action = new Update();

        return $Action->execute($visitVisitor, $attributes);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VisitVisitorService {}
