<?php
/**
 * License Plate Input Trait
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Traits
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Traits;


use Livewire\Attributes\Validate;


/**
 * License Plate Input Trait
 *
 * @version     1.1.0 / 2025-02-15
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
trait WithLicensePlateInput
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @var         string|null $licensePlate
     */
    public ?string $licensePlate;


    /**
     * @var         array $licensePlates
     */
    public array $licensePlates = [];


    /**
     *
     * @var         string $target
     */
    public string $target = 'create';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-04-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function addLicensePlate()
    {
        $this->validate([
            'licensePlate' => 'required' // |regex:/^[A-ZÄÖÜ]{1,3}-[A-Z]{1,2}-[1-9][0-9]{0,2}[0-9EH]?$/
        ]);
        $this->licensePlates[] = $this->licensePlate;
        $this->licensePlate = '';

        $this->dispatch('license-plates-updated', target: $this->target, licensePlates: $this->licensePlates);

    } // addLicensePlate()


    /**
     *
     * @version     1.0.0 / 2025-04-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function clearLicensePlates()
    {
        $this->licensePlates = [];

    } // clearLicensePlates()


    /**
     *
     * @version     1.0.0 / 2025-04-22
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function removeLicensePlate($index)
    {
        unset($this->licensePlates[$index]);

        $this->dispatch('license-plates-updated', target: $this->target, licensePlates: $this->licensePlates);

    } // removeLicensePlate()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // trait WithLicensePlateInput {}
