<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use BplanModules\VisitorManagement\Enums\ContactOptionContext;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_contact_options');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_contact_options', function (Blueprint $Table) {
            $Table->id();
            $Table->boolean('active')->default(1);

            $Table->timestamps();

            $Table->enum('context', [array_column(ContactOptionContext::cases(), 'name')]);
            $Table->json('labels');
            $Table->unsignedTinyInteger('sort_sequence')->default(0);
            $Table->string('value', 255);
            $Table->string('value_prefix', 255)->nullable();

            new CodeGenerator($Table, [
                'columns' => [
                    'context' => [
                        'sortable',
                    ],
                    'labels' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                        'sortable' => true,
                    ],
                    'sort_sequence' => [
                        'sortable' => true,
                    ],
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => [
                        'actions' => [
                            'show',
                        ],
                        'method' => 'only',
                    ],
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
            ]);

        });
    } // up()


};
