<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use BplanModules\VisitorManagement\Enums\ImportContext;
use BplanModules\VisitorManagement\Enums\ImportType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_import_logs');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_import_logs', function (Blueprint $Table) {
            $Table->id();

            $Table->timestamps();

            $Table->timestamp('begin')->nullable()->comment('Beginn der Verarbeitung.');
            $Table->unsignedInteger('error_count')->default(0)->comment('Anzahl fehlerhafter Zeilen.');
            $Table->json('errors')->nullable();
            $Table->unsignedInteger('failure_count')->default(0)->comment('Anzahl fehlerhafter Zeilen.');
            $Table->json('failures')->nullable();
            $Table->enum('import_context', [array_column(ImportContext::cases(), 'name')]);
            $Table->string('import_file_name', 255);
            $Table->enum('import_type', [array_column(ImportType::cases(), 'name')]);
            $Table->unsignedInteger('row_count')->comment('Anzahl verarbeiteter Zeilen (ohne Leer- und Kommentarzeilen).');
            $Table->decimal('runtime', 15, 10)->nullable()->comment('Laufzeit der Verarbeitung.');

            new CodeGenerator($Table, [
                'columns' => [
                    'begin' => [
                        'sortable' => true,
                    ],
                    'error_count' => [
                        'sortable' => true,
                    ],
                    'errors' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_ARRAY,
                    ],
                    'failure_count' => [
                        'sortable' => true,
                    ],
                    'failures' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_ARRAY,
                    ],
                    'import_context' => [
                        'rules' => [
                            'required',
                            'Rule::enum(ImportContext::class)',
                        ],
                        'sortable' => true,
                    ],
                    'import_type' => [
                        'rules' => [
                            'required',
                            'Rule::enum(ImportType::class)',
                        ],
                        'sortable' => true,
                    ],
                    'runtime' => [
                        'sortable' => true,
                    ],
                ],
                'exclude' => [
                    'laravel.action.delete',
                    'laravel.action.update',
                ],
                'routing' => [
                    'data' => 'readOnly',
                    'terminal' => 'readOnly',
                ],
                'uses' => [
                    'jsonapi.request' => [
                        'BplanModules\\VisitorManagement\\Enums\\ImportContext',
                        'BplanModules\\VisitorManagement\\Enums\\ImportType',
                        'Illuminate\\Validation\\Rule',
                    ],
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
            ]);

        });
    } // up()


};
