<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use BplanModules\VisitorManagement\Enums\ProcessStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_visitors');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_visitors', function (Blueprint $Table) {
            $Table->id();
            $Table->boolean('active')->default(1);

            $Table->timestamps();
            $Table->softDeletes('deleted_at');

            $Table->boolean('anonymized')->default(0);
            $Table->string('comments', 500)->nullable();
            $Table->string('company', 100)->nullable();
            $Table->string('email', 255)->nullable();
            $Table->string('first_name', 50)->nullable();
            $Table->unsignedInteger('import_failure_count')->default(0)->comment('Anzahl der Fehler beim letzten Import.');
            $Table->json('import_failures')->nullable()->comment('Liste der Fehler des letzten Imports.');
            $Table->string('last_name', 50)->nullable();
            $Table->string('mobile_phone_number', 20)->nullable();
            $Table->string('mobile_phone_number_country_code', 4)->nullable();
            $Table->string('preferred_language', 2)->default(config('app.fallback_locale'));
            $Table->timestamp('safety_briefing_confirmed')->nullable()->comment('Zeitstempel wann die Sicherheitsunterweisung bestätigt wurde.');
            $Table->boolean('verified')->default(0);

            new CodeGenerator($Table, [
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'company' => [
                        'sortable' => true,
                    ],
                    'email' => [
                        'rules' => [
                            'nullable',
                            'email',
                            'max:255',
                        ],
                        'sortable' => true,
                    ],
                    'first_name' => [
                        'sortable' => true,
                    ],
                    'import_failure_count' => [
                        'sortable' => true,
                    ],
                    'import_failures' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_ARRAY,
                    ],
                    'last_name' => [
                        'sortable' => true,
                    ],
                    'preferred_language' => [
                        /*
                        **  Anpassung der Rule für das Terminal.
                        **  Eigentlich ist das Feld nicht nullable. */
                        'rules' => [
                            'nullable',
                            'string',
                            'max:2',
                        ],
                    ],
                    'safety_briefing_confirmed' => [
                        'sortable' => true,
                    ],
                ],
                'routing' => [
                    // 'terminal' => 'relationOnly',
                    'terminal' => [
                        'actions' => [
                            'destroy',
                        ],
                        'method' => 'except'
                    ],
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                        'Notifiable' => 'Illuminate\\Notifications\\Notifiable',
                    ],
                ],
                'uses' => [
                    'laravel.model' => [
                        'Illuminate\\Notifications\\Notification',
                    ],
                ],
            ]);

        });
    } // up()


};
