<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use BplanModules\VisitorManagement\Enums\ProcessStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visit_appointment_status_logs');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visit_appointment_status_logs', function (Blueprint $Table) {
            $Table->id();

            $Table->timestamp('created_at');

            $Table->foreignId('appointment_id')->constrained(table: 'visit_appointments', indexName: 'visit_appointment_status_logs_FK_appointment_id');
            $Table->foreignId('entry_point_id')->nullable()->comment('ID des Zugangspunkts über den die Statusänderung erfolgte.')->constrained(table: 'visit_entry_points', indexName: 'visit_appointment_status_logs_FK_entry_point_id');
            $Table->tinyInteger('process_status')->default(0)->comment('Siehe Enums/ProcessStatus: 0 = Open, 1 = Initialized, 2 = CheckedIn, 3 = CalledIn, 4 = Entered, 5 = Ongoing, 6 = CheckedOut, 7 = Finished');

            $Table->index('appointment_id', 'visit_appointment_status_logs_FKI_appointment_id');
            $Table->index('entry_point_id', 'visit_appointment_status_logs_FKI_entry_point_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'appointment_id' => [
                        'reverseRelationName' => 'appointment'
                    ],
                    'process_status' => [
                        'sortable' => true,
                    ],
                ],
                'exclude' => [
                    'laravel.action.delete',
                    'laravel.action.update',
                ],
                'uses' => [
                    'laravel.model' => [
                        'BplanModules\\VisitorManagement\\Enums\\ProcessStatus',
                    ],
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
            ]);

        });
    } // up()


};
