<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders\Dev;


use BplanModules\VisitorManagement\Models\VisitContactGroup;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitContactGroupSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        VisitContactGroup::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => 'Emergency',
                "internal" => 1,
                "labels" => '{"de": "Notfall", "en": "Emergency", "it": "Emergenza"}',
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => null,
                "internal" => 0,
                "labels" => '{"de": "Allgemein", "en": "General", "it": "Generale"}',
            ], [
                "id" => 3,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => null,
                "internal" => 0,
                "labels" => '{"de": "Einkauf", "en": "Procurement", "it": "Acquisti"}',
            ], [
                "id" => 4,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => null,
                "internal" => 0,
                "labels" => '{"de": "Verkauf", "en": "Sales", "it": "Vendite"}',
            ],

        ]);
    } // run()

} // class VisitContactGroupSeeder extends Seeder {}
