<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders\Dev;


use BplanModules\VisitorManagement\Enums\EntryPointDirection;
use BplanModules\VisitorManagement\Enums\EntryPointType;
use BplanModules\VisitorManagement\Enums\TokenPrefix;
use BplanModules\VisitorManagement\Models\VisitEntryPoint;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitEntryPointSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        VisitEntryPoint::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "direction" => EntryPointDirection::Both,
                "entry_point_type" => EntryPointType::Terminal,
                "label" => 'Web-Frontend',
                "token" => TokenPrefix::EntryPoint->value."0000",
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "direction" => EntryPointDirection::Both,
                "entry_point_type" => EntryPointType::Terminal,
                "label" => 'Terminal 1',
                "token" => TokenPrefix::EntryPoint->value."0001",
            ], [
                "id" => 3,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "direction" => EntryPointDirection::In,
                "entry_point_type" => EntryPointType::Gate,
                "label" => 'Schrankensystem 1',
                "token" => TokenPrefix::EntryPoint->value."3901",
            ], [
                "id" => 4,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "direction" => EntryPointDirection::Out,
                "entry_point_type" => EntryPointType::Gate,
                "label" => 'Schrankensystem 2',
                "token" => TokenPrefix::EntryPoint->value."3902",
            ],

        ]);
    } // run()

} // class VisitEntryPointSeeder extends Seeder {}
