<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders;


use BplanModules\VisitorManagement\Models\VisitLocation;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitLocationSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        VisitLocation::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => 'Lahnstein',
                "coordinates" => null,
                "email" => '',
                "house_number" => '1',
                "labels" => '{"de":"Zentrale", "en":"Main Office"}',
                "location_type_id" => 3,
                "master_id" => null,
                "phone_number" => '+49262114000',
                "street" => 'Hohenrhein',
                "zip_code" => '56112',
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "address_addition" => null,
                "city" => null,
                "coordinates" => null,
                "email" => null,
                "house_number" => null,
                "labels" => '{"de":"Laderampe 1", "en":"Loading Ramp 1"}',
                "location_type_id" => 1,
                "master_id" => 1,
                "phone_number" => null,
                "street" => null,
                "zip_code" => null,
            ],

        ]);
    } // run()

} // class VisitLocationSeeder extends Seeder {}
