<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/visitor-management
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanModules\VisitorManagement\Database\Seeders;


use BplanModules\VisitorManagement\Models\VisitOpeningHour;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VisitOpeningHourSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');
        $visitTypeIds = [1, 3, 4, 5, 6, 7, 8, 9, 10, 11];
        $logisticsVisitTypeIds = [4, 5, 7, 8, 9];

        $data = [];

        foreach ($visitTypeIds as $visitTypeId) {
            for ($i = 0; $i < 7; $i++) {
                $begin = '07:00';
                $end = '17:00';
                $open = 1;

                if ($visitTypeId === 1) {   // AccessAuthorization
                    $begin = '00:00';
                    $end = '23:59';
                    $open = 1;

                } else {
                    if (in_array($visitTypeId, $logisticsVisitTypeIds)) {
                        $begin = '07:00';
                        $end = '15:00';
                    }
                    if ($i === 0 || $i === 6) {
                        $begin = null;
                        $end = null;
                        $open = 0;
                    }
                }
                $data[] = [
                    "active" => 1,
                    "created_at" => $date,
                    "updated_at" => $date,
                    "begin" => $begin,
                    "end" => $end,
                    "open" => $open,
                    "visit_type_id" => $visitTypeId,
                    "weekday" => $i,
                ];
            }
        }
        VisitOpeningHour::insert($data);

    } // run()

} // class OpeningHourSeeder extends Seeder {}
